# head {#head}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`head(X, [n=1])`

## Arguments {#arguments}

**X** is a vector/matrix/table.

**n** \(optional\) is a positive integer. The default value is 1.

## Details {#details}

Return the first *n* element\(s\) of a vector, or the first *n* columns of a matrix, or the first *n* rows of a table.

## Examples {#examples}

```
x=1..10;
head(x);

// output: 1

x=1..10$2:5;
x;
```

|\#0|\#1|\#2|\#3|\#4|
|---|---|---|---|---|
|1|3|5|7|9|
|2|4|6|8|10|

```
x.head();

// output: [1,2]

head(x,2);
```

|\#0|\#1|
|---|---|
|1|3|
|2|4|

```
x=table(1..5 as a, 6..10 as b);
x;
```

|a|b|
|---|---|
|1|6|
|2|7|
|3|8|
|4|9|
|5|10|

```
head(x);

/* output:
b->6
a->1
*/

x.head(2);
```

|a|b|
|---|---|
|1|6|
|2|7|

Related function: [tail](../t/tail.md)

