# hasNull {#hasnull}

## Syntax {#syntax}

`hasNull(X)`

## Arguments {#arguments}

**X** is a scalar/vector/matrix/table.

## Details {#details}

-   For a scalar, return true if it is null.
-   For a vector, return true if at least one element is null.
-   For a matrix or a table, return true if at least one element of at least one column is null.

Please refer to related functions: [isNull](../i/isNull.md), [nullFill](../n/nullFill.md).

## Examples {#examples}

```
hasNull NULL;
// output: true

x=00f;
hasNull x;
// output: true

hasNull 5;
// output: false

hasNull(1 2 NULL 4 NULL 6);
// output: true

x=((NULL,1),2);
hasNull x;
// output: false

m=(1 NULL 3 4 5 6)$2:3;
hasNull m;
// output: true

t=table(`AAPL`IBM`MSFT as sym, 2200 NULL 4500 as qty);
hasNull(t);
// output: true
```

