# grant {#grant}

## Syntax {#syntax}

`grant(userId|groupId,accessType,[objs])`

## Arguments {#arguments}

**userId** \| **groupId** is a string indicating a user name or a group name.

**accessType** is the privilege type or memory limit.

**objs** \(optional\) is a STRING scalar/vector indicating the objects that the priviledges specified by *accessType* applies to. "\*" means all objects. When *accessType* is COMPUTE\_GROUP\_EXEC, *objs* must be compute group\(s\).

See the privilege table in [User Access Control](../../Maintenance/UserAccessControl.md) for the values that *accessType* and *objs* can take.

**Note:**

-   When managing privileges for shared tables, stream tables or streaming engines, *objs* must be in the format "tableName@nodeAlias" or "nodeAlias:tableName".
-   When managing privileges for IMOLTP databases and tables, *objs* must be in the format "oltp://database/table@nodeAlias" or "oltp://database@nodeAlias".

## Details {#details}

Grant a user or group with the specified privilege. Specific functionalities include:

-   Administrators can grant all privileges \(any accessType\) to users or user groups through this command.

-   Administrators can grant users all privileges \(*accessType*\) through this command, but regular users, after having the relevant OWNER privileges, can only grant the following privileges through this command: TABLE\_READ, TABLE\_WRITE, TABLE\_INSERT, TABLE\_UPDATE, TABLE\_DELETE, DB\_READ, DB\_WRITE, DB\_INSERT, DB\_UPDATE, DB\_DELETE, DBOBJ\_DELETE, DBOBJ\_CREATE and VIEW\_EXEC.

-   accessType = DB\_OWNER

    When the *accessType*is DB\_OWNER, *objs*can be specified as a prefix rule to limit the databases that the user can create and manage. Multiple prefix rules can be passed in a vector to *objs*. If there is already a global DB\_OWNER privilege granted, adding prefix rules will be invalid. Prefix rules do not override each other if one contains the other. The authorized prefix rules can be viewed using the `getUserAccess` function.

    When a user attempts to create or manage a database, if the user's privilege is denied globally, the operation is prohibited; otherwise, the user's privileges are the union of all the prefix rules, meaning if the database name matches any of the authorized prefix rules, the operation is permitted.

    Note that the prefix rules can only be specified with function `grant`, and revoked with `revoke`, but cannot be denied with `deny`. When the *accessType*is DB\_OWNER, `deny` only takes effect at a global scope and overrides all previously-defined prefix rules.

-   Query Memory Limit Privilege

    Set the memory limit of a query result \(when *accessType* = QUERY\_RESULT\_MEM\_LIMIT\) or the memory limit of a task group \(when *accessType* = TASK\_GROUP\_MEM\_LIMIT\) for a user. Different from commands [setMemLimitOfQueryResult](../s/setMemLimitOfQueryResult.md) and [setMemLimitOfTaskGroupResult](../s/setMemLimitOfTaskGroupResult.md), `grant` only applies to the specified user \(group is not supported\). You can use `revoke` to remove the memory limit set with `grant`.

-   accessType = CREATE\_SHARED\_VAR

    When the accessType is CREATE\_SHARED\_VAR, this privilege controls whether a user can create shared variables. This privilege only takes effect if the system parameter *enableSharedVarCreationControl* is set to true. This is a global privilege and does not support object-level \(objs\) scoping. By default, the admin user has this privilege, while the guest user and newly created ordinary users do not have it and must be explicitly granted. Newly created administrator users also do not have this privilege by default, but they can explicitly grant it to themselves. If the parameter is set to false, the permission control is disabled and all users can create shared variables.


## Examples {#examples}

Grant all members of group "production" the read privilege to all tables and databases:

```
grant(`production, TABLE_READ, "*")
```

Grant all members of group "research" the write privilege to the table "dfs://db1/t1":

```
grant(`research, TABLE_WRITE, "dfs://db1/t1")
```

Grant all members of group "research" the table creation privilege to the databases "dfs://db1" and "dfs://db2":

```
grant("research", DBOBJ_CREATE, ["dfs://db1","dfs://db2"])
```

Grant the user "AlexSmith" the DB\_MANAGE privilege:

```
grant("AlexSmith", DB_MANAGE)
```

Grant the user "AlexSmith" the script execution privilege:

```
grant("AlexSmith", SCRIPT_EXEC)
```

Grant the user "AlexSmith" the script test privilege:

```
grant("AlexSmith", TEST_EXEC)
```

Grant the user "AlexSmith" the execution privilege of function `f1` under the namespace test1:

``` {#codeblock_tqz_qhj_b1c}
grant("AlexSmith", VIEW_EXEC, "test1::f1")
```

Grant the user "AlexSmith" the execution privilege of all functions under the namespace test2:

``` {#codeblock_fg2_shj_b1c}
grant("AlexSmith", VIEW_EXEC, "test2::*")
```

The namespace must be a module name. For example, for a module test.dos under the directory moduleDir/mod1/test.dos, grant the user the execution privileges of all functions under the module namespace:

``` {#codeblock_cqr_thj_b1c}
grant("AlexSmith", VIEW_EXEC, "mod1::test::*")
```

The following script is not supported:

``` {#codeblock_ptr_5hj_b1c}
grant("AlexSmith", VIEW_EXEC, "mod1::*")
```

If privilege on a namespace is granted, and later the function views in the namespace are removed with `dropFunctionView`, once the last function view in the namespace is deleted, the authorization for that namespace will also be automatically revoked. Similarly, if there are no function views in the namespace at the time of authorization, an exception will be thrown. For function views without a namespace, they are considered global. The following two methods are equivalent:

``` {#codeblock_gcg_whj_b1c}
grant("AlexSmith", VIEW_EXEC, "::f")
grant("AlexSmith", VIEW_EXEC, f)
```

Set the memory limit of query result to 4 GB for the user "AlexSmith".

```
grant("AlexSmith", QUERY_RESULT_MEM_LIMIT, 4)
```

Grant user "AlexSmith" the privilege to create and manage databases with prefix "dbxxx".

```
grant("AlexSmith", DB_OWNER, "dfs://ddb*")
```

Multiple patterns can be passed in a vector to *objs*. For example:

``` {#codeblock_ghp_l1j_21c}
grant("AlexSmith", DB_OWNER, ["dfs://ddb_prefix1*","dfs://ddb_prefix2*"])
```

