# gramSchmidt {#gramschmidt}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`gramSchmidt(X, [normalize = false])`

## Arguments {#arguments}

**X** is a matrix where each column \(as a vector\) is linearly independent, i.e., the matrix has column full rank. It cannot contain any null values.

**normalize** \(optional\) is a Boolean value indicating whether to output a normalized orthogonal matrix. The default value is false.

## Details {#details}

This function converts a matrix of full column rank into an orthogonal matrix.

**Return value**: a matrix of DOUBLE type.

## Examples {#examples}

```
x = matrix([2 3 5, 3 6 2, 8 3 6]);
gramSchmidt(x)

/* output:
col1    col2    col3
2.0000  1.2105  4.7932
3.0000  3.3157  -2.1968
5.0000  -2.4736 -0.5991
*/

// If normalize=true, a normalized orthogonal matrix is returned.
gramSchmidt(x, true)
/* output:
col1    col2    col3
0.3244      0.2808  0.9033
0.4867      0.7693  -0.414
0.8111      -0.5739 -0.1129
*/

x = matrix([1 4, 2 5, 3 6]);
gramSchmidt(x)
// An error is raised when the columns of the matrix are linearly dependent.
vector set must be linearly independent
```

