# getUserTableAccessRecords {#getusertableaccessrecords}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUserTableAccessRecords([from=0], [to])`

## Arguments {#arguments}

**from** \(optional\) is an integral or temporal number indicating the start time of the query. The default value is 0, indicating the queried records starts from the record at 1970.01.01 00:00.

**to** \(optional\) is an integral or temporal number indicating the end time of the query. The default value is null, indicating the query includes records up to the current time.

Note that *from* must be no greater than *to*.

## Details {#details}

Get the information stored in query logs \(located at *&lt;HomeDir&gt;/resource/access.log\)* within the specified time range. This function can only be called by the administrator on a data node.

It returns a table containing the following fields:

-   timestamp: a timestamp of NANOTIMESTAMP type. If type is sql, it indicates the time when the query execution starts; If type is rowCount or memUsage, it indicates the time when data is read.

-   rootQueryId: the query ID of a SQL query. It is the unique identifier for DFS SQL queries. A DFS query is split into multiple sub-queries by partition. This ID is the root ID for the DFS query and its sub-queries.

-   userId: the login user ID.

-   database: the queried database.

-   table: the queried table.

-   type: the message type, which can be sql, rowCount or memUsage.

-   value:

    -   the execution count \(always 1\) when type is *sql*.
    -   the number of records involved in the query when type is rowCount.
    -   the memory usage \(in bytes\) of the query results when type is *memUsage*.

## Examples {#examples}

``` {#codeblock_pn2_3ly_g1c}
getUserTableAccessRecords(2023.12.30T09:18:35.894150296,2023.12.30T09:18:35.894538439)
/* output:
timestamp	rootQueryId	userId	database	table	type	value	script
2023.12.30T09:18:35.894150296	e892855b-7843-1492-0140-a85810662006	admin	dfs://rangedb	pt	sql	1	select count(x) as count_x from pt
2023.12.30T09:18:35.894497304	e892855b-7843-1492-0140-a85810662006	admin	dfs://rangedb	pt	rowCount	43	
2023.12.30T09:18:35.894501600	e892855b-7843-1492-0140-a85810662006	admin	dfs://rangedb	pt	memUsage	516	
*/
```

