# getUserHardwareUsage {#getuserhardwareusage}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUserHardwareUsage([from=0], [to])`

## Arguments {#arguments}

**from** \(optional\) is an integral or temporal number indicating the start time of the query. The default value is 0, indicating the queried records starts from the record at 1970.01.01 00:00.

**to** \(optional\) is an integral or temporal number indicating the end time of the query. The default value is null, indicating the query includes records up to the current time.

Note that *from* must be no greater than *to*.

## Details {#details}

Use this function to retrieve hardware resource usage of users within a specified time period from query logs \(*&lt;HomeDir&gt;/resource/hardware.log*\). This function requires resource tracking to be enabled \(configured via *resourceSamplingInterval*\) and can only be called by the administrator on a data node.

**Return value**: It returns a table containing the following columns:

-   timestamp: a timestamp of NANOTIMESTAMP type.
-   userId: the user ID.
-   cpu: the number of CPU threads used by the user.
-   memory: the memory used \(in bytes\) by the user.
-   send: the amount of data \(in bytes\) sent during a sampling interval.
-   recv: the amount of data \(in bytes\) received during a sampling interval. Note that there may be some discrepancy in the measured data volume, with a potential deviation of up to 2KB.

## Examples {#examples}

``` {#codeblock_zfd_jnk_b2c}
login("admin", "123456")
select sum(send), sum(recv) from pnodeRun(getUserHardwareUsage) group by userId, node
```

Output:

|userId|node|sum\_send|sum\_recv|
|------|----|---------|---------|
|admin|datanode8902|197,783|464|
|admin|datanode8903|375,911|438|
|admin|datanode8904|1,080,171|735,817|
|guest|datanode8902|2,144|216|
|guest|datanode8903|120|0|
|guest|datanode8904|399|0|
|user1|datanode8902|80,222|0|
|user1|datanode8903|120|0|
|user1|datanode8904|83,361|328|
|user2|datanode8902|80,100|0|

