# getAuthenticatedUserTicket {#getauthenticateduserticket}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getAuthenticatedUserTicket([expire])`

## Arguments {#arguments}

**expire** is a DATETIME scalar indicating the expiration time of the user ticket to be generated.

## Details {#details}

A currently logged in user can use this function to generate a dynamic ticket and set the expiration time of the ticket. The user can then use the generated ticket for passwordless login via the `authenticateByTicket(ticket)` function.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
login("user1", "123456")
getAuthenticatedUserTicket(2030.12.31T12:00:00)
/ output: 
VQEpuZYCbwhPDj6qvuyW+zDwdnQI3HiUhfJOpyUW/J5X5XZmponkmE6n5COI1xUP
xCVr29VHsNYOV00tGZrFkGKPOJhjWJtSt85ok5s8EVYXwZCgdrYjdharJLBk/e04
u1oBC0/6nD4WdDM68pCbsZgUqDe94+czqG0M21Sy8PA=
/
```

