# getAclAuditLog {#getaclauditlog}

## Syntax {#Syntax .section}

`getAclAuditLog([userId], [startTime], [endTime], [opType])`

## Arguments {#Arguments .section}

**userId** \(optional\) is a STRING scalar or vector indicating the user ID. If it is not provided \(left as the default value of null\), it means that ACL operations of all users are obtained.

**startTime**\(optional\) is an integral scalar or temporal scalar of DATE, MONTH, DATETIME, TIMESTAMP, DATEHOUR, or NANOTIMESTAMP type. It is the start time of the log. The default value is 1970.01.01, indicating midnight on January 1, 1970.

**endTime**\(optional\) is an integral scalar or temporal scalar of DATE, MONTH, DATETIME, TIMESTAMP, DATEHOUR, or NANOTIMESTAMP type. It is the end time of the log. The default value is null, indicating the current time. Note that *endTime* must be greater than *startTime*.

**opType**\(optional\) is a STRING scalar or vector indicating the operation type. If it is not provided \(left as the default value of null\), it means that all ACL operations are obtained. For *opType* options, see the descriptions in the table following this discussion of Arguments.

## Details {#Details .section}

Obtain the ACL operations of specific *opType* executed by user *userId* between *startTime* and *endTime* \(exclusive\).

**Return value:** A table containing the following columns:

-   userId: The ID of the user perform the operation.
-   startTime: The time when the operation started.
-   endTime: The time when the operation ended.
-   opType: The operation type.
-   opDetail: The detailed operation.
-   remoteIp: The IP address of the client that submits the operation.
-   remotePort: The port of the client that submits the operation.

The corresponding *opDetail* of each *opType*are shown below:

|opType|opDetail|Description|
|------|--------|-----------|
|login|login userId=xxx encrypted=true/false|user login|
|logout|logout userId=xxx sessionOnly=true/false|user logout|
|createUser|userId=xxx groupId=xxx isAdmin=true/false|create user|
|createGroup|groupId=xxx userIds=\[xxx,xxx,…\]|create user group|
|resetPwd|userId=xxx|reset password|
|changePwd||change password|
|deleteUser|userId=xxx|delete user|
|deleteGroup|groupId=xxx|delete user group|
|addGroupMember|userIds=\[xxx,xxx,…\] groupIds=\[xxx,xxx,…\]|add member\(s\) to group|
|deleteGroupMember|userIds=\[xxx,xxx,…\] groupIds=\[xxx,xxx,…\]|delete member\(s\) from group|
|grant|userOrGroupId=xxx accessType=xxx objs=\[xxx,xxx,…\]|grant privilege|
|deny|userOrGroupId=xxx accessType=xxx objs=\[xxx,xxx,…\]|deny privilege|
|revokeByDFSOperation|oldObj=xxx newObjs=\[xxx,xxx,…\]|revoke related privilegesperforming upon executingdropDatabase, dropTable or dropColumn!|
|replaceByDFSOperation|oldObj=xxx newObjs=\[xxx,xxx,…\]|update related privileges upon executingrenameTable and replaceColumn!|
|revoke|userOrGroupId=xxx accessType=xxx objs=\[xxx,xxx,…\]|revoke privilege|
|createCatalog|catalog=xxx|create catalog|
|dropCatalog|catalog=xxx|delete catalog|
|renameCatalog|catalog=xxx new catalog=xxx|rename catalog|
|renameSchema|catalog=xxx schema=xxx new schema=xxx|rename schema|
|createSchema|catalog=xxx dbUrl=xxx schema=xxx|create schema|
|dropSchema|catalog=xxx schema=xxx|delete schema|
|tryDropSchemaByDatabase|dbUrl=xxx|remove corresponding schemas from the catalog upon deleting the database|
|setMaxJobPriority|maxJobPriority=xxx|specify the highest priority of the jobs|
|setMaxJobParallelism|maxJobParallelism=xxx|specify the maximum number of task that can be concurrently executed for the jobs|
|newConnection||receive a new connection|
|closeConnection||close connection|
|saveClusterNodes||modify *nodes.cfg*|
|saveClusterNodesConfigs||modify *cluster.cfg*|
|saveControllerConfigs||modify *controller.cfg*|
|loadClusterNodesConfigs||read *nodes.cfg*|
|loadControllerConfigs||read *controller.cfg*|

## Examples {#examples .section}

First, set *enableAuditLog*=true in the configuration file. Then, use getAclAuditLog to query all ACL operations.

``` {#codeblock_nyh_wlv_x1c}
login("admin","123456")
createUser("user1","abcdec")
grant("user1",TABLE_READ,"*")
logout()
login("admin","123456")
getAclAuditLog()
```

Output:

|userId|time|opType|opDetail|remoteIp|remotePort|
|------|----|------|--------|--------|----------|
|guest|2025.01.02 14:26:52.738224592|newConnection||192.168.0.130|55,428|
|guest|2025.01.02 14:26:53.049518446|login|login userId=admin encrypted=false|192.168.0.130|55,428|
|admin|2025.01.02 14:26:53.059963095|createUser|userId=user1 groupIds=\[\] isAdmin=false|192.168.0.130|55,428|
|admin|2025.01.02 14:26:53.060387348|grant|userOrGroupId=user1 accessType=TABLE\_READ objs=\[\]|192.168.0.130|55,428|
|guest|2025.01.02 14:26:53.060426785|logout|logout userId=admin sessionOnly=true|192.168.0.130|55,428|
|guest|2025.01.02 14:26:53.060576365|login|login userId=admin encrypted=false|192.168.0.130|55,428|
|guest|2025.01.08 09:46:49.710254224|newConnection||192.168.0.130|41,746|
|guest|2025.01.08 09:46:52.124830142|login|login userId=admin encrypted=false|192.168.0.130|41,746|
|admin|2025.01.08 09:46:52.127153771|createUser|userId=user1 groupIds=\[\] isAdmin=false|192.168.0.130|41,746|
|admin|2025.01.08 09:46:52.127752666|grant|userOrGroupId=user1 accessType=TABLE\_READ objs=\[\]|192.168.0.130|41,746|

**Parent topic:**[Functions](../../Functions/category.md)

