# getUserLockedStatus {#getUserLockedStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getUserLockedStatus()`

## Details {#details}

Retrieve the lock status of users in the system. It can only be executed by administrators when the configuration parameter *enhancedSecurityVerification* is set to true.

Return value: A table with the following columns:

-   user: The username of the locked user.
-   IP: The IP address from which the user is locked. If the user was locked by an administrator using the `lockUser` function, this column displays “\*“.
-   lockTime: The time when the lock was initiated.
-   unlockTime: The expected unlock time. If the user was locked by an administrator using the `lockUser` function, this column is empty.

**Examples**

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getUserLockedStatus()
```

|user|IP|lockTime|unlockTime|
|----|---|--------|----------|
|user2|\*|2025.03.27 11:27:36.597||
|user1|192.168.0.140|2025.03.27 11:27:23.916|2025.03.27 11:32:23.916|

