# getUserAccess {#getuseraccess}

## Syntax {#section_axl_wbb_dzb .section}

`getUserAccess([userIds], [finalAccess=false])`

## Arguments {#section_uty_wbb_dzb .section}

**userId** \(optional\) is a STRING scalar/vector indicating one or multiple user names.

**finalAccess** \(optional\) is a Boolean value that specifies whether the obtained result is the privileges that ultimately take effect, i.e., the privileges for both the user and the groups the user belongs to are taken into account. The default value is false.

## Details {#section_pll_xbb_dzb .section}

This function returns privileges for specific users.

When *userId* is not specified, it returns the privileges for the current user.

When *userId*is specified \(only by administrators\):

-   If *finalAccess* = false, the obtained access is the explicit privileges applied to the user.

-   If *finalAccess* = true, the obtained access is the privileges that ultimately take effect.


**Return value**: A table with the following columns

|Column|Description|
|------|-----------|
|userId|The user name|
|groups|The group to which the user belongs|
|isAdmin|Whether the user is an administrator|
|MAX\_JOB\_PRIORITY|An integer between 0 and 8 indicating the highest priority of the jobs submitted by the user. It is specified by the command `setMaxJobPriority`.|
|MAX\_PARALLELISM|An integer indicating the maximum number of tasks that can be executed in parallel for a job submitted by the user. It is specified by the command `setMaxJobParallelism`.|
|QUERY\_RESULT\_MEM\_LIMIT|The memory limit for a query result. It is a floating-point number indicating memory usage \(in GB\). You can use `grant` to set the limit and `revoke` to remove.|
|TASK\_GROUP\_MEM\_LIMIT|The memory limit of a task group. It is a floating-point number indicating memory usage in GB. You can use `grant` to set the limit and `revoke` to remove.|
|MAX\_PARTITION\_NUM\_PER\_QUERY|The maximum number of partitions that can be queried at one time. It is an integer and a value of -1 indicates that this privilege is not configured. You can use `grant` to set the limit and `revoke` to remove.|

The following privileges are listed with permission state "allow" / "none" / "deny": ACCESS\_READ, ACCESS\_INSERT, ACCESS\_UPDATE, ACCESS\_DELETE, VIEW\_EXEC, SCRIPT\_EXEC, TEST\_EXEC, DBOBJ\_CREATE, DBOBJ\_DELETE, DB\_MANAGE, DB\_OWNER, VIEW\_OWNER, COMPUTE\_GROUP\_EXEC, TABLE\_SENSITIVE\_VIEW, DB\_SENSITIVE\_VIEW, CREATE\_SHARED\_VARS, MCP\_MANAGE, MCP\_DEVELOP, MCP\_EXEC.

**Note:**

-   Since version 3.00.2, compute group privileges are returned.
-   Since version 3.00.0, catalog privileges are returned.
-   Version 1.30.21/2.00.9 onwards extends privileges at the table level. The original TABLE\_WRITE field is now replaced with fields TABLE\_INSERT, TABLE\_UPDATE, and TABLE\_DELETE.
-   As the DB\_READ, DB\_WRITE, DB\_INSERT, DB\_UPDATE, and DB\_DELETE privileges apply to tables in databases, only table-level privileges are returned.

The remaining columns in the table display the specific objects \(tables, views or databases\) that the user is granted/denied access to:

|objs|
|----|
|TABLE\_READ\_allowed|
|TABLE\_READ\_denied|
|TABLE\_INSERT\_allowed|
|TABLE\_INSERT\_denied|
|TABLE\_UPDATE\_allowed|
|TABLE\_UPDATE\_denied|
|TABLE\_DELETE\_allowed|
|TABLE\_DELETE\_denied|
|DB\_READ\_allowed|
|DB\_READ\_denied|
|DB\_INSERT\_allowed|
|DB\_INSERT\_denied|
|DB\_UPDATE\_allowed|
|DB\_UPDATE\_denied|
|DB\_DELETE\_allowed|
|DB\_DELETE\_denied|
|VIEW\_EXEC\_allowed|
|VIEW\_EXEC\_denied|
|DBOBJ\_CREATE\_allowed|
|DBOBJ\_CREATE\_denied|
|DBOBJ\_DELETE\_allowed|
|DBOBJ\_DELETE\_denied|
|DB\_OWNER\_allowed|
|DB\_MANAGE\_allowed|
|DB\_MANAGE\_denied|
|CATALOG\_READ\_allowed|
|CATALOG\_READ\_denied|
|CATALOG\_INSERT\_allowed|
|CATALOG\_INSERT\_denied|
|CATALOG\_UPDATE\_allowed|
|CATALOG\_UPDATE\_denied|
|CATALOG\_DELETE\_allowed|
|CATALOG\_DELETE\_denied|
|COMPUTE\_GROUP\_EXEC\_allowed|
|COMPUTE\_GROUP\_EXEC\_denied|
|TABLE\_SENSITIVE\_VIEW\_allowed|
|TABLE\_SENSITIVE\_VIEW\_denied|
|DB\_SENSITIVE\_VIEW\_allowed|
|DB\_SENSITIVE\_VIEW\_denied|
|MCP\_EXEC\_allowed|
|MCP\_EXEC\_denied|

**Parent topic:**[Functions](../../Functions/category.md)

