# getTopicProcessedOffset {#gettopicprocessedoffset}

## Syntax {#syntax}

`getTopicProcessedOffset(topic)`

## Arguments {#arguments}

**topic** is the subscription topic returned by function [subscribeTable](../s/subscribeTable.md)

## Details {#details}

-   If parameter *persistOffset* of function `subscribeTable` is true, return the offset of the last subscribed message that has been processed.
-   If parameter *persistOffset* of function `subscribeTable` is false, return -1.

## Examples {#examples}

```
share streamTable(1000:0, `time`sym`qty, [TIMESTAMP, SYMBOL, INT]) as trades
trades_1 = streamTable(1000:0, `time`sym`qty, [TIMESTAMP, SYMBOL, INT])
topic=subscribeTable(tableName="trades", actionName="trades_1", offset=0, handler=append!{trades_1}, msgAsTable=true, persistOffset=true)
def writeData(n){
   timev = 2018.10.08T01:01:01.001 + timestamp(1..n)
   symv =take(`A`B, n)
   qtyv = take(1, n)
   insert into trades values(timev, symv, qtyv)
}
writeData(6);
select * from trades_1;
```

|time|sym|qty|
|----|---|---|
|2018.10.08T01:01:01.002|A|1|
|2018.10.08T01:01:01.003|B|1|
|2018.10.08T01:01:01.004|A|1|
|2018.10.08T01:01:01.005|B|1|
|2018.10.08T01:01:01.006|A|1|
|2018.10.08T01:01:01.007|B|1|

```
getTopicProcessedOffset(topic);
// output: 5
```

