# getTableSchemaByCluster {#getTableSchemaByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getTableSchemaByCluster(clusterName, dbUrl, table)`

## Arguments {#arguments}

**clusterName** is a STRING scalar indicating the name of the cluster.

**dburl** is a STRING scalar indicating the path of the database.

**table** is a STRING scalar indicating the name of the table.

## Details {#details}

Get the schema of the specified table. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A dictionary. See function [schema\(table\)](../s/schema.md) for details.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getTableSchemaByCluster("MoMSender", "dfs://db1", "dt")
   
/* Output:
   colDefs->name      typeString typeInt extra comment
   --------- ---------- ------- ----- -------
timestamp SECOND     10                   
   sym       STRING     18                   
   qty       INT        4                    
   price     DOUBLE     16                   
   chunkPath->
   partitionColumnIndex->-1
   
*/
```

Related Function: [schema](../s/schema.md).

