# getTableAccess {#getTableAccess}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getTableAccess(dbUrl, table)`

## Arguments {#arguments}

**dbUrl** is a string indicating the database URL.

**table** is a string indicating the table name.

## Details {#details}

Allow users to get a detailed view of users and groups with privileges of the specified DFS table.

**Note:**This function can only be invoked by administrators or by users with DB\_OWNER or DB\_MANAGE privileges of the database.

**Return value**: A table with the following columns:

-   name: The user or group name.
-   type: User or group.
-   TABLE\_READ, TABLE\_INSERT, TABLE\_UPDATE, TABLE\_DELETE: The specific privileges. The states can be ALLOW, DENY, or NONE. For more information on user access privileges, please refer to [User Access Control](../../Tutorials/access_control.md).


## Examples {#examples}

User1 with the DB\_OWNER privilege creates the DFS table dfs://testDB/pt with following settings

-   Grants TABLE\_READ privilege to user2.
-   Denies TABLE\_INSERT privilege to user3.
-   Grants TABLE\_DELETE privilege to group1.

Use `getTableAccess` to view the permission set of testDB.

``` {#codeblock_n2w_nyg_mcc}
login(`user1, `123456)
getTableAccess("dfs://testDB", "pt")
```

Output:

|name|type|TABLE\_READ|TABLE\_INSERT|TABLE\_UPDATE|TABLE\_DELETE|
|:---|:---|:----------|:------------|:------------|:------------|
|group1|group|NONE|NONE|NONE|ALLOW|
|user3|user|NONE|DENY|NONE|NONE|
|user2|user|ALLOW|NONE|NONE|NONE|
|admin|user|ALLOW|ALLOW|ALLOW|ALLOW|

Related functions: [getDBAccess](getDBAccess.md)

