# getTSDBTableIndexCacheStatus {#gettsdbtableindexcachestatus}

## Syntax {#syntax .section}

`getTSDBTableIndexCacheStatus()`

## Arguments {#args .section}

None

## Details {#details .section}

When querying a TSDB table, the indexes \(including zonemap\) of related level files will be loaded to the memory. This function is used to obtain the memory usage \(in bytes\) of the level file indexes for each loaded table. Combined with function `getTSDBDataStat`, it helps you to check whether the number of sort keys set for tables is reasonable.

Return a table with the following columns:

-   dbName: the database name.

-   chunkId: the chunk ID.

-   tableName: the table name.

-   memUsage: the size of the memory used \(in bytes\).


## Examples {#examples .section}

``` {#codeblock_jff_5zt_x1c}
t = table(1 2 1 1 2 2 3 as month, `Rome`Paris`London`Paris`Rome`London`Rome as city, 200 500 100 300 300 400 400 as sold)
db_name = "dfs://tsdb_01"
if (existsDatabase(db_name)) {
    dropDatabase(db_name)
}
db = database(db_name, HASH, [INT, 4], , 'TSDB')

pt = db.createPartitionedTable(t, "pt", "month", ,"sold")
pt.append!(t)

pt1 = db.createPartitionedTable(t, "pt1", "month", ,"sold")
pt1.append!(t)

flushTSDBCache()

getTSDBTableIndexCacheStatus()
```

|dbName|chunkId|tableName|memUsage|
|------|-------|---------|--------|
|dfs://tsdb\_01|01e891fa-f66d-7599-7544-4e0449f4e608|pt1\_3|680|
|dfs://tsdb\_01|81c0f8f7-e195-b298-da4a-d007492f4733|pt1\_3|680|
|dfs://tsdb\_01|17f8bc0b-946e-f688-374c-955c586faccf|pt\_2|296|
|dfs://tsdb\_01|1df88c41-bccf-449b-504c-5978df9cc03f|pt\_2|680|
|dfs://tsdb\_01|10371e0c-685a-51b1-3042-1ba289514bb9|pt1\_3|296|
|dfs://tsdb\_01|0be81d1e-1962-108b-274e-3dc2632921bc|pt\_2|680|

Related functions: [getTSDBDataStat](getTSDBDataStat.md), [getLevelFileIndexCacheStatus](getLevelFileIndexCacheStatus.md)

**Parent topic:**[Functions](../../Functions/category.md)

