# getTSDBCompactionTaskStatus {#gettsdbcompactiontaskstatus}

## Syntax {#syntax}

`getTSDBCompactionTaskStatus([count])`

## Arguments {#arguments}

**count** \(optional\) is a non-negative integer. Return the status of the latest count compaction tasks. The default value is 0, indicating that all completed compaction tasks \(up to 256 latest tasks\) and uncompleted tasks are returned.

## Details {#details}

Obtain the status of TSDB level file compaction tasks. The function can only be executed on a data node.

Return a table with the following columns:

-   volume: the volume where the compaction is performed. It is set by the configuration parameter *volumes*.

-   level: the level of files for compaction.

-   chunkId: the ID of chunk where the compaction is performed.

-   tableName: the physical name of the table where the compaction is performed.

-   files: the level files involved in the current compaction.

-   force: whether the compaction is triggered by `triggerTSDBCompaction`.

-   receivedTime: the timestamp when the compaction task enqueued.

-   startTime: the timestamp when the compaction task started.

-   endTime: the timestamp when the compaction task ended.

-   errorMessage: If a task failed, the column displays the failure cause; otherwise it is left empty.


## Examples {#examples}

```
getTSDBCompactionTaskStatus()
```

|volume|level|chunkId|tableName|files|force|receivedTime|startTime|endTime|errorMessage|
|------|-----|-------|---------|-----|-----|------------|---------|-------|------------|
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|0|e0e00bc2-b81e-6eb9-4d01-7bb17fb39595|pt\_2|0\_00000006,0\_00000011,|true|2023.06.22T12:47:32.009|2023.06.22T12:47:32.010|2023.06.22T12:47:32.182||
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|1|a9dfccad-cec1-0786-480a-9ae809481a8b|pt\_2|0\_00000003,0\_00000007,|true|2023.06.22T12:47:32.010|2023.06.22T12:47:32.182|2023.06.22T12:47:32.326||
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|1|331324ce-b49f-94ac-4da8-a4bcf6c34e1c|pt\_2|0\_00000004,0\_00000010,|true|2023.06.22T12:47:32.010|2023.06.22T12:47:32.326|2023.06.22T12:47:32.451||
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|2|f3597e0f-6ad9-6eb6-45c8-d42adc5c50f7|pt\_2|0\_00000002,0\_00000008,|true|2023.06.22T12:47:32.010|2023.06.22T12:47:32.451|2023.06.22T12:47:32.527||
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|2|d36ac640-3428-069b-4382-0b9608b94d17|pt\_2|0\_00000005,0\_00000009,|true|2023.06.22T12:47:32.010|2023.06.22T12:47:32.527|2023.06.22T12:47:32.616||
|/home/DolphinDB/DolphinDB\_Linux64\_V2.00.9/server/clusterDemo/data/node1/storage|2|e0e00bc2-b81e-6eb9-4d01-7bb17fb39595|pt\_2|0\_00000016,0\_00000021,|true|2023.06.22T12:47:33.058|2023.06.22T12:47:33.058|2023.06.22T12:47:33.151||

Related function: [triggerTSDBCompaction](../t/triggerTSDBCompaction.md)

