# getSupportBundle {#getsupportbundle}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getSupportBundle([dir])`

## Arguments {#arguments}

**dir** \(optional\) specifies the directory to store the support bundle. The default path is *&lt;HomeDir&gt;*\(which can be obtained with [getHomeDir](getHomeDir.md)\) for a standalone mode, and the sibling directory of *&lt;HomeDir&gt;* for a cluster mode.

### Details {#details}

Generate a file of support bundle containing all configuration information and return the file path. The function can only be called on a data node or compute node.

The file contains the following information:

<table id="table_cwf_1bb_dzb"><thead><tr><th>

Block

</th><th>

Description

</th><th>

Info Source

</th></tr></thead><tbody><tr><td>

VERSION

</td><td>

the server version

</td><td>

`version()`

</td></tr><tr><td>

CONFIGS

</td><td>

the configuration information.

</td><td>

-   standalone mode: *dolphindb.cfg*;
-   cluster mode: *cluster.cfg*, *cluster.nodes*, *controller.cfg*

</td></tr><tr><td>

DB AND TABLE SCHEMA

</td><td>

the schema of each database and table

</td><td>

`schema`

</td></tr><tr><td>

LICENSE AND MACHINE INFO

</td><td>

license, CPU cores and memory usage

</td><td>

license file: *dolphindb.lic*

</td></tr><tr><td>

OLAP CACHE ENGINE STATUS

</td><td>

The status of OLAP cache engine on the current node and the memory usage of each node

</td><td>

`pnodeRun(getOLAPCacheEngineSize)` `pnodeRun(getOLAPCacheEngineStat)`

</td></tr><tr><td>

TSDB META

</td><td>

the metadata of all chunks in the TSDB database

</td><td>

`pnodeRun(getTSDBMetaData)`

</td></tr><tr><td>

REDO LOG GC STATUS

</td><td>

the redo log status

</td><td>

`pnodeRun(getRedoLogGCStat)`

</td></tr><tr><td>

TRANSACTION STATUS

</td><td>

the transaction status

</td><td>

`pnodeRun(getTransactionStatus)`

</td></tr><tr><td>

TABLETS META

</td><td>

the metadata of the 100 chunks in the cluster with the most rows

</td><td>

`select top 100 * from pnodeRun(getTabl etsMeta{"%","%",false,-1}) order by rowNum desc`

</td></tr><tr><td>

ANOMALOUS CHUNK STATUS

</td><td>

the status of anomalous chunks. Anomaly means chunks in recovery, with different version or replica counts.

</td><td>

`getClusterChunksStatus()`

</td></tr></tbody>
</table>### Examples {#examples}

```
getSupportBundle()
// output: /home/dolphindb/server/getSupportBundle.1655869793424

getSupportBundle("/home/dolphindb/sup")
// output: /home/dolphindb/sup/getSupportBundle.1655869853178
```

