# getStreamingStat {#getstreamingstat}

## Syntax {#syntax}

`getStreamingStat()`

## Arguments {#arguments}

**stat** \(optional\) is a STRING scalar or vector, specifying which status table\(s\) to return. Available options include: pubConns, subConns, pubTables, persistWorkers, subWorkers, udpPubTables.

## Details {#details}

Monitors the status of streaming jobs.

**Return value**:

-   If *stat* specifies a single table, it returns the corresponding status table.
-   If *stat* specifies multiple tables or is not specified, it returns a dictionary containing status tables.

The status tables include:

-   Table *pubConns* displays the status of the connections between the local publisher node and all of its subscriber nodes. Each row represents a subscriber node.

    |Column Name|Description|
    |-----------|-----------|
    |client|IP address and port number of a subscriber node|
    |queueDepthLimit|The maximum depth \(number of records\) of the message queue that is allowed on the publisher node|
    |queueDepth|Current depth \(number of records\) of the message queue on the publisher node|
    |tables|All shared streaming tables in the publisher node|

-   Table *subConns* displays the status of the connections between the local subscriber node and the publisher nodes. Each row is a publisher node that the local node subscribes to.

    |Column Name|Description|
    |-----------|-----------|
    |publisher|A publisher node alias|
    |cumMsgCount|The number of messages that have been received|
    |cumMsgLatency|The average latency of all received messages|
    |LastMsgLatency|The latency of the last received message|
    |lastUpdate|The last time a message was received|

    Latency in this table means the time consumed from the moment a message arrives at the publisher node message queue to the moment the message arrives at the subscriber node message queue.

-   Table *pubTables* displays the status of stream tables. Each row represents a stream table.

    |Column Name|Description|
    |-----------|-----------|
    |tableName|the shared stream table|
    |subscriber|IP address and port number of a subscriber node|
    |msgOffset|offset of the last published record|
    |actions|the subscription task name|

-   Table *persistWorkers* displays the status of workers \(threads\) responsible for stream table persistence.

    |Column Name|Description|
    |-----------|-----------|
    |workerId|Worker ID|
    |queueDepthLimit|The maximum depth \(number of records\) of a message queue that is allowed for table persistence|
    |queueDepth|Current depth \(number of records\) of the message queue for table persistence|
    |tables|Names of the persisted streaming tables|

-   Table *subWorkers* displays the status of workers of subscriber nodes.

    |Column Name|Description|
    |-----------|-----------|
    |workerId|Worker ID. An empty "workerId" column means the subscriber node has not received data.|
    |topics|Subscription topics|
    |type|The subscription method, which can be tcp \(TCP\) or udp \(UDP multicast\).|
    |queueDepthLimit|The maximum depth \(number of records\) of a message queue that is allowed on the subscriber node|
    |queueDepth|Current depth \(number of records\) of the message queue on the subscriber node|
    |processedMsgCount|The number of messages that have been processed|
    |lastMsgId|the last message ID|
    |failedMsgCount|The number of messages that failed to be processed|
    |lastFailedMsgId|the last failed message ID|
    |lastFailedTimestamp|The timestamp of the latest failed message|
    |lastErrMsg|the last error information on the failed message|
    |msgAsTable|a BOOLEAN value indicating how the subscribed data is ingested into handler. True means the data is ingested as a table, and false means data is ingested as a tuple.|
    |batchSize|the number of messages batch processed by the handler|
    |throttle|a numeric scalar \(in seconds\), indicating the waiting time for the handler to process the messages if the batchSize condition has not been reached since the last process|
    |hash|a non-negative integer, indicating which subscription executor to process the incoming messages|
    |filter|the filtering column of a stream table|
    |persistOffset|a Boolean value, indicating whether to persist the offset of the last processed message|
    |timeTrigger|a Boolean value. True means that the handler is triggered at the intervals specified by the parameter throttle even if no new messages arrive|
    |handlerNeedMsgId|a Boolean value, default false. True means that the handler supports two parameters: msgBody and msgId|
    |raftGroup|the raft group ID|

-   Table *udpPubTables*displays the publishing status using UDP multicast.

    |Column Name|Description|
    |-----------|-----------|
    |tableName|The publisher table|
    |channel|The UDP channel|
    |msgOffset|The offset of the last published record|
    |actions|The subscription task name|
    |subNum|The number of subscriptions|


## Examples {#examples}

```
getStreamingStat().pubConns;
getStreamingStat().subConns;
getStreamingStat().pubTables;
getStreamingStat().persistWorkers;
getStreamingStat().subWorkers;
```

