# getStreamingSQLStatus {#getStreamingSQLStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamingSQLStatus([queryId])`

## Arguments {#arguments}

**queryId** \(optional\) A STRING scalar representing the ID name for the registered streaming SQL query.

## Details {#details}

Get the status of streaming SQL query.

-   If specify the *queryId*, return its status.
-   If not specify, return the status of all streaming SQL queries of the current user. Return streaming SQL queries of all users if called by the admin.

**Return value**: A table containing the following columns:

-   queryId: The ID name for the registered streaming SQL query.
-   user: Name of the user who register the query.
-   registerTime: The time of query registration.
-   status: The status of the current query, which can be:
    -   SQL\_REGISTERED: Registered but not running.
    -   SQL\_RUNNING: Running normally and results are updated in real time.
    -   SQL\_STOPPED: Stopped.
    -   INTERNAL\_ERROR: Error.
-   sqlQuery: The statement of streaming SQL query.
-   involvedTables: Tables involved in the query.
-   lastErrorMessage: The last error message, if any.

## Examples {#examples}

``` {#codeblock_y55_32x_mgc}
t=table(1..10 as id,rand(100,10) as val)
share t as st
declareStreamingSQLTable(st)
registerStreamingSQL("select avg(val) from st","sql_avg") 

// Get the status of streaming SQL query
getStreamingSQLStatus("sql_avg")

```

|queryId|user|registerTime|status|sqlQuery|involvedTables|lastErrorMessage|
|-------|----|------------|------|--------|--------------|----------------|
|sql\_avg|admin|2025.08.09 03:33:40.781|SQL\_REGISTERED|select avg\(val\) from st|st||

**Related functions:** [declareStreamingSQLTable](../d/declareStreamingSQLTable.md), [registerStreamingSQL](../r/registerStreamingSQL.md)

