# getStreamTableFilterColumn {#getstreamtablefiltercolumn}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamTableFilterColumn(streamTable)`

## Arguments {#arguments}

**streamTable** is a stream table object.

## Details {#details}

Return the filter column name of a stream table. The filter column is specified by the function [setStreamTableFilterColumn](../s/setStreamTableFilterColumn.md).

## Examples {#examples}

```
share streamTable(10000:0,`time`symbol`price, [TIMESTAMP,SYMBOL,INT]) as trades
setStreamTableFilterColumn(trades, `symbol)
trades_1=table(10000:0,`time`symbol`price, [TIMESTAMP,SYMBOL,INT])
filter=symbol(`IBM`GOOG)
subscribeTable(tableName=`trades, actionName=`trades_1, handler=append!{trades_1}, msgAsTable=true, filter=filter);

n=100
time=take(2018.01.01T09:30:00.000,n)
symbol=take((`IBM`GOOG`AAPL`C`BABA),n)
price=1..n

t=table(time,symbol,price)
trades.append!(t)

// Obtain the filtering column of trades which is specified by the function setStreamTableFilterColumn
getStreamTableFilterColumn(trades); 
// output: symbol
```

