# getStreamEngine {#getstreamengine}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getStreamEngine(name)`

## Arguments {#arguments}

**name** is a string indicating the name of the stream engine. It is the only identifier of the stream engine. It can have letter, number and "\_". It must start with a letter.

## Details {#details}

Return the handle of a stream engine. It can be used as the handler of [subscribeTable](../s/subscribeTable.md).

## Examples {#examples}

```
share streamTable(1000:0, `time`sym`qty, [TIMESTAMP, SYMBOL, INT]) as trades
outputTable = table(10000:0, `time`sym`sumQty, [TIMESTAMP, SYMBOL, INT])
tradesAggregator = createTimeSeriesEngine("StreamAggregatorDemo",3, 3, <[sum(qty)]>, trades, outputTable, `time, false,`sym, 50)
subscribeTable(, "trades", "tradesAggregator", 0, append!{tradesAggregator}, true)

def writeData(n){
   timev = 2018.10.08T01:01:01.001 + timestamp(1..n)
   symv =take(`A`B, n)
   qtyv = take(1, n)
   insert into trades values(timev, symv, qtyv)
}

writeData(6);
h = getStreamEngine("StreamAggregatorDemo")
```

