# getSlaveReplicationStatus {#getslavereplicationstatus}

## Syntax {#section_axm_wz1_dzb .section}

`getSlaveReplicationStatus([limit=-1])`

## Arguments {#section_bkz_wz1_dzb .section}

**limit** \(optional\) is an integer that specifies the maximum tasks that can be returned in the result. The default value is -1, meaning no limit is placed.

## Details {#section_tnp_xz1_dzb .section}

This function displays the cluster replication task status in the slave cluster. It can only be executed by an administrator on the controller of a slave cluster. If *slaveReplicationDBScope* is configured, the function only returns replication status for the specified databases.

**Return value:**A table where finished tasks are listed first, then followed by unfinished tasks. The function returns:

-   All tasks if *limit* is not specified
-   Up to *limit* tasks \(including both completed and pending\) if specified
-   Maximum of 10,000 most recent completed tasks
-   Pending tasks starting from the earliest timestamp until reaching the specified limit

Return columns:

-   taskId: ID of asynchronous replication task.
-   masterTid: transaction ID in the master cluster.
-   groupId: ID of the group to which the asynchronous replication task belongs.
-   queueId: ID of the execution queue to which the replication task belongs.
-   operationType: operation type of the replication task.
-   createTime: the time \(of NANOTIMESTAMP type\) when the slave cluster receives the task from the master cluster.
-   dbName: the database name where the task is executed.
-   tableName: the table name where the task is executed.
-   srcIP: IP of the data node where data of write tasks is stored.
-   srcPort: port of the data node where data of write tasks is stored.
-   finishTime: the time \(of NANOTIMESTAMP type\) when the task is finished.
-   executionNode: the data node where the task is executed.
-   state: the task state, including WAITING, EXECUTING, FINISHED, and FAILED.
-   details: If state = FAILED, returns the failure cause; If state = FINISHED, provides additional description on the task.

## Examples {#section_tlc_11b_dzb .section}

``` {#codeblock_gtq_11b_dzb}
getSlaveReplicationStatus();
```

|taskId|masterTid|groupId|queueId|operationType|createTime|dbName|tableName|srcIP|srcPort|finishTime|executionNode|state|details|
|------|---------|-------|-------|-------------|----------|------|---------|-----|-------|----------|-------------|-----|-------|
|1|1|1|0|CREATE\_DOMAIN|2022.11.08T10:50:37.425056956|db://test\_dropPartition\_value||localhost|8002|2022.11.08T10:50:37.452792885|NODE2|FINISHED||
|2|2|2|1|CREATE\_PARTITIONED\_TABLE|2022.11.08T10:50:37.425056988|db://test\_dropPartition\_value|pt|localhost|8002|2022.11.08T10:50:37.479906033|NODE3|FINISHED||
|3|3|3|2|APPEND|2022.11.08T10:50:37.425057012|db://test\_dropPartition\_value|pt|localhost|8002|2022.11.08T10:50:37.638746819|NODE1|FINISHED||
|4|4|4|3|DROP\_PARTITION|2022.11.08T10:50:37.425057037||pt|localhost|8002|2022.11.08T10:50:37.869783336|NODE2|FINISHED||

Related functions: [getMasterReplicationStatus](getMasterReplicationStatus.md)

