# getSessionMemoryStat {#getsessionmemorystat}

## Syntax {#syntax}

`getSessionMemoryStat()`

## Arguments {#arguments}

None

## Details {#details}

Return information about memory usage of all sessions on the current node. It returns a table containing the following columns:

-   userId: the user ID or the cache type \(in the format of \_\_xxx\_\_\).

-   sessionId: the session ID.

-   memSize: memory usage of all sessions \(in Bytes\).

-   remoteIP: the IP address of the client that initiates the session.

-   remotePort: the port number of the client that initiates the session.

-   createTime: the creation time \(of TIMESTAMP data type\) of session.

-   lastActiveTime: last timestamp of the execution.


The cache type can be:

|Cache Types|Meaning|
|-----------|-------|
|\_\_DimensionalTable\_\_|the cache of dimension tables \(in Bytes\)|
|\_\_SharedTable\_\_|the cache of shared tables \(in Bytes\)|
|\_\_OLAPTablet\_\_|the cache of the OLAP databases \(in Bytes\)|
|\_\_OLAPCacheEngine\_\_|the memory usage of OLAP cache engine \(in Bytes\)|
|\_\_OLAPCachedSymbolBase\_\_|the cache of SYMBOL base in OLAP engine \(in Bytes\)|
|\_\_DFSMetadata\_\_|the memory usage of DFS metadata in distributed storage \(in Bytes\)|
|\_\_TSDBCacheEngine\_\_|the cache of the TSDB engine \(in Bytes\)|
|\_\_TSDBLevelFileIndex\_\_|the cache of level file index in the TSDB engine \(in Bytes\)|
|\_\_TSDBCachedSymbolBase\_\_|the cache of SYMBOL base in TSDB engine \(in Bytes\)|
|\_\_StreamingPubQueue\_\_|the unprocessed messages in a publisher queue|
|\_\_StreamingSubQueue\_\_|the unprocessed messages in a subscriber queue|
|\_\_IOTDBStaticTableCache\_\_|the static table \(in Bytes\)|
|\_\_IOTDBLatestKeyCache\_\_|the latest value table \(in Bytes\)|

Note:

-   This function does not return the memory occupied by tasks being executed in the session.

-   For the columns *createTime* and *lastActiveTime* in the result table, versions before 1.30.21.4/2.00.9.4 return GMT time. From version 1.30.21.4/2.00.9.4 onwards, these columns return time in your current time zone.


## Examples {#examples}

```
t = getSessionMemoryStat();
t;
```

|userId|sessionId|memSize|remoteIP|remotePort|createTime|lastActiveTime|
|------|---------|-------|--------|----------|----------|--------------|
|\_\_DimensionalTable\_\_|0|0.0.0.0|||||
|\_\_SharedTable\_\_|0|0.0.0.0|||||
|\_\_OLAPTablet\_\_|0|0.0.0.0|||||
|\_\_OLAPCacheEngine\_\_|0|0.0.0.0|||||
|\_\_OLAPCachedSymbolBase\_\_|0|0.0.0.0|||||
|\_\_DFSMetadata\_\_|2769|0.0.0.0|||||
|\_\_TSDBCacheEngine\_\_|0|0.0.0.0|||||
|\_\_TSDBLevelFileIndex\_\_|0|0.0.0.0|||||
|\_\_TSDBCachedSymbolBase\_\_|0|0.0.0.0|||||
|\_\_StreamingPubQueue\_\_|0|0.0.0.0|||||
|\_\_StreamingSubQueue\_\_|0|0.0.0.0|||||
|admin|2882591513|1416|60.176.105.0|20861|2023.02.15T02:15:22.384|2023.02.15T02:24:16.307|

