# getSchemasByCluster {#getSchemasByCluster}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

``getSchemasByCluster(clusterName, catalogName)``

## Arguments {#arguments}

**clusterName** is a STRING scalar indicating the name of the cluster.

**catalogName** is a STRING scalar indicating the name of the catalog.

## Details {#details}

Return all schemas under the specified catalog in the cluster. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value**: A table with the following columns:

-   schema: A string indicating the name of the schema.
-   dbUrl: A string indicating the path of the database.

**Examples**

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
// MoMSender cluster: 
database(directory="dfs://db1", partitionType=RANGE, partitionScheme=0 5 10)
database(directory="dfs://db2", partitionType=RANGE, partitionScheme=0 5 10)
createSchema("catalog1", "dfs://db1", "schema1")
createSchema("catalog1", "dfs://db2", "schema2")

// MOM cluster: 
getSchemasByCluster("MoMSender", "catalog1")
```

|schema|dbUrl|
|------|-----|
|schema1|dfs://db1|
|schema2|dfs://db2|

