# getRunningQueries {#getrunningqueries}

## Syntax {#syntax}

`getRunningQueries()`

## Arguments {#arguments}

None

## Details {#details}

Return descriptive information about the SQL queries that are being executed on the local node. It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|userID|the user ID|
|sessionID|the session ID|
|jobID|the job ID|
|rootID|the root job ID|
|level|the level of jobs. The root job starts from level 0, the tasks broken down from the root job are marked as level 1, and subtasks level 2, and so on.|
|startTime|the start time of a query \(of NANOTIMESTAMP type\)|
|endTime|the end time of a query \(of NANOTIMESTAMP type\)|
|jobDesc|the job description|
|errorMsg|error messages|
|remoteIP|the IP address of the client that initiates a query|

To use this function, we must set *perfMonitoring*=1 in the configuration file to enable performance monitoring.

## Examples {#examples}

```
getRunningQueries();
```

|userID|sessionID|jobID|rootID|level|startTime|endTime|jobDesc|errorMsg|remoteIP|
|------|---------|-----|------|-----|---------|-------|-------|--------|--------|
|admin|738481026|88e738a8-a749-4dcb-9cfe-740df2d9ce7d|88e738a8-a749-4dcb-9cfe-740df2d9ce7d|0|2019.02.07T19:02:26.809905612||select count\(\*\) as count from pt||192.168.1.106|

