# getRules {#getRules}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getRules([engineName])`

## Arguments {#arguments}

**engineName** \(optional\) is a STRING vector indicating the rule engine name\(s\). If unspecified, the function returns the rules of all rule engines on the current node.

## Details {#details}

Get the rules of the specified rule engine, including the rule set, checking policy, and callback function.

**Return value**: A dictionary whose key is the engine name and value is another dictionary containing:

-   ruleSets: A dictionaryindicating the rule sets of the engine, where:
    -   key: Rule name. Return a default rule set with the key “Default“.
    -   value: Specific rules.
-   policy: The checking policy of the engine.
-   callback: The callback function of the engine. If unspecified, it is an empty string.

## Examples {#examples}

``` {#codeblock_zzp_z51_ddc}
// Specify the rule set
x = [1, 2, NULL]
y = [ [ < value > 1 > ], [ < price < 2 >, < price > 6 > ], [ < value*price > 10 > ] ]
ruleSets = dict(x, y)

// Create rule engines
names = `sym`value`price`quantity
types = [INT, DOUBLE, DOUBLE, DOUBLE]
dummy = table(1:0, names, types)
outputNames = `sym`value`price`rule
outputTypes = [INT, DOUBLE, DOUBLE, BOOL[]]
outputTable = table(10:0, outputNames, outputTypes)
test = createRuleEngine(name="ruleEngineTest", ruleSets=ruleSets, dummyTable=dummy, outputColumns=["sym","value","price"], outputTable=outputTable, policy="all", ruleSetColumn="sym")
test2 = createRuleEngine(name="ruleEngineTest2", ruleSets=ruleSets, dummyTable=dummy, outputColumns=["sym","value","price"], outputTable=outputTable, policy="all", ruleSetColumn="sym")

// Query the rules of the specified engine
getRules(["ruleEngineTest"])
/*
ruleEngineTest->
    ruleSets->
        Default->(value * price > 10)
        1->(value > 1)
        2->(price < 2, price > 6)

    policy->all
    callback->
*/

// Update the rules of the specified engine
updateRule("ruleEngineTest", 1, [<value > 2>])

// Query the rules again after update
getRules()
/*
ruleEngineTest->
    ruleSets->
        Default->(value * price > 10)
        1->(value > 2)
        2->(price < 2, price > 6)

    policy->all
    callback->
*/
```

Related functions: [createRuleEngine](../c/createRuleEngine.md), [updateRule](../u/updateRule.md), and [deleteRule](../d/deleteRule.md).

