# getQueryStatus {#getquerystatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getQueryStatus()`

## Arguments {#arguments}

None

## Details {#details}

Get the status of a running query initialized on the current node. Return a table with the following columns:

-   id: The total count of the query tasks that have been executed.

-   sessionId: ID of the session where the query is initialized. Please note that sessionId of the jobs submitted with `submitJob` cannot be obtained.

-   userId: The user who initialized the task.

-   query: The query statement.

-   startTime: The timestamp when the query starts.

-   elapsedTimeInMs: The elapsed time \(in ms\) of the query.

-   memoryUsage: The memory used by the variables and results of the query \(in bytes\).

-   totalTaskCount: Total count of tasks.

-   completedTaskCount: Count of completed tasks.

-   percentComplete: The completion percentage of the query.


The function can only be called on the node where a query is initialized.

## Examples {#examples}

```
getQueryStatus();
```

|id|sessionId|userId|query|startTime|elapsedTimeInMs|memoryUsage|totalTaskCount|completedTaskCount|percentComplete|
|---|---------|------|-----|---------|---------------|-----------|--------------|------------------|---------------|
|2|1166953221|admin|select ticker, id, x from pt|2022.06.14 08:15:00.606|1052|184550000|4|1|0.25|

