# getPersistenceMeta {#getpersistencemeta}

## Syntax {#syntax}

`getPersistenceMeta(table)`

## Arguments {#arguments}

**table** is a table object.

## Details {#details}

Get metadata of a persistent stream table.

Return a dictionary with the following keys:

-   lastLogSeqNum: the latest log sequence number of raft log.
-   sizeInMemory: the number of records in memory.

-   asynWrite: whether to persist data with asynchronous mode.

-   totalSize: the total number of records in the stream table.

-   compress: whether to save compressed data.

-   memoryOffset: the offset position of the first message in memory relative to all records in the stream table. memoryOffset = totalSize - sizeInMemory.

-   sizeOnDisk: the number of records that have been persisted to disk.

-   retentionMinutes: how long \(in terms of minutes\) the log file will be kept. The default value is 1440 minutes \(1 day\).

-   persistenceDir: the path to the persistent data.

-   hashValue: the identifier of the thread responsible for persisting the table to disk. If persistenceWorkerNum&gt;1, hashValue may not be 0.

-   diskOffset: the offset position of the first message on disk relative to all records in the stream table.


## Examples {#examples}

```
colName=["time","x"]
colType=["timestamp","int"]
t = streamTable(100:0, colName, colType);
enableTableShareAndPersistence(table=t, tableName=`st, cacheSize=1200000)
go;

for(s in 0:200){
   n=10000
   time=2019.01.01T00:00:00.000+s*n+1..n
   x=rand(10.0, n)
   insert into st values(time, x)
}

getPersistenceMeta(st);

/* output:
astLogSeqNum->-1
sizeInMemory->800000
asynWrite->true
totalSize->2000000
raftGroup->-1
compress->true
memoryOffset->1200000
retentionMinutes->1440
sizeOnDisk->2000000
persistenceDir->/dolphindb/server/streamPersistDir/st
hashValue->0
diskOffset->0
*/
```

