# getPerf {#getperf}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getPerf()`

## Arguments {#arguments}

None

## Details {#details}

`getPerf` returns various performance monitoring metrics of the local node as a dictionary.

The dictionary contains the following fields:

-   runningJobs: The number of running jobs.

-   jobLoad: The CPU load of a job.

-   avgLoad: average CPU load.

-   queuedJobs: The number of jobs in queue.

-   lastMinuteNetworkSend: The data \(in bytes\) sent in the last minute.

-   lastMinuteNetworkRecv: The data \(in bytes\) received in the last minute.

-   lastMinuteReadVolume: The data \(in bytes\) read from disk in the last minute.

-   lastMinuteWriteVolume: The data \(in bytes\) written to disk in the last minute.

-   lastMsgLatency: The latency \(in ns\) of the last received message.

-   cumMsgLatency: The cumulative latency \(in ns\) of the messages.

-   maxLast10QueryTime: The maximum execution time \(in ns\) of the previous 10 finished queries.

-   maxLast100QueryTime: The maximum execution time \(in ns\) of the previous 100 finished queries.

-   medLast10QueryTime: The median execution time \(in ns\) of the previous 10 finished queries.

-   medLast100QueryTime: The median execution time \(in ns\) of the previous 100 finished queries.

-   maxRunningQueryTime: The maximum elapsed time \(in ns\) of the queries that are currently running.

-   diskFreeSpaceRatio: The available space ratio.

-   diskReadRate: The rate \(in bytes/s\) at which data are read from disk.

-   diskWriteRate: The rate \(in bytes/s\) at which data are written to disk.

-   diskFreeSpace: The available disk space \(in bytes\).

-   diskCapacity: The disk capacity \(in bytes\).

-   cpuUsage: CPU usage.

-   memoryAlloc: The total memory \(in bytes\) allocated to DolphinDB on the node.

-   memoryUsed: The memory \(in bytes\) used by the node.

-   networkSendRate: The rate at which data are sent \(in bytes/s\).

-   networkRecvRate: The rate at which data are received \(in bytes/s\).

-   connectionNum: The number of connections to the local node.


## Examples {#examples}

```
getPerf();
/* output:
lastMinuteWriteVolume->684
runningJobs->0
lastMsgLatency->0
maxLast100QueryTime->0
avgLoad->0.0040625
diskWriteRate->144
lastMinuteNetworkSend->228528
queuedJobs->0
lastMinuteNetworkRecv->525533
maxLast10QueryTime->0
medLast100QueryTime->0
maxRunningQueryTime->0
diskReadRate->2663
cumMsgLatency->0
medLast10QueryTime->0
diskFreeSpaceRatio->0
cpuUsage->0.306748466257669
memoryUsed->29053456
jobLoad->0
networkSendRate->4460
memoryAlloc->35463168
lastMinuteReadVolume->159940
networkRecvRate->8950
diskCapacity->0
diskFreeSpace->0
*/
```

