# getOrcaStateMachineEventTaskStatus {#getOrcaStateMachineEventTaskStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaStateMachineEventTaskStatus()`

## Details {#details}

Stream Master treats incoming requests as events, which are added to the state machine queue and wait for execution. This function is used to retrieve the status of tasks in the state machine.

**Return value:** a table containing the following fields:

-   **id:** Event ID.
-   **type:** Type of the event. Possible values include:
    -   SUBMIT\_REQUEST**:** Event triggered by a user request to submit a streaming graph.
    -   SUBMIT**:** Streaming graph submission event.
    -   RESUBMIT\_REQUEST**:** Event triggered by a user request to resubmit a streaming graph.
    -   DROP\_REQUEST**:** Event triggered by a user request to delete a streaming graph.
    -   DROP\_CALLBACK**:** Internal event for the deletion callback of a streaming graph.
    -   DROP**:** Streaming graph destruction event.
    -   NODE\_DOWN**:** Node failure event.
    -   NODE\_READY**:** Node restart event.
    -   RECOVER**:** Task recovery event.
    -   INTERNAL**:** Internal event.
-   **state:** Running status of the event, including pending, running, and finished.
-   **retries:** Number of retries. When the event is not processed correctly, the state machine will attempt retries.
-   **scheduledTime:** Scheduled time indicating when the event should be executed.
-   **startTime:** Actual start time when the event processing began.
-   **endTime:** End time of the event processing.
-   **detail:** Properties related to the event.
-   **errorMessage:** Error message generated during event processing, if any.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaStateMachineEventTaskStatus()
```

