# getOrcaCheckpointSubjobInfo {#getOrcaCheckpointSubjobInfo}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaCheckpointSubjobInfo([name])`

## Arguments {#arguments}

**name** \(optional\) is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Retrieve the Checkpoint subtask information of the specified streaming graph.

If **name** is not specified, the function returns the Checkpoint subtask information of all streaming graphs in Orca.

**Return value:** a table containing the following fields:

-   **checkpointId:** Checkpoint ID.
-   **jobId:** Streaming graph ID.
-   **subjobId:** Subtask ID.
-   **firstBarrierArrTs:** The timestamp when the subtask receives the first Barrier.
-   **barrierAlignTs:** The timestamp when Barrier alignment is completed in the subtask.
-   **barrierForwardTs:** The timestamp when the subtask forwards the Barrier to downstream operators.
-   **status:** Status of the Checkpoint subtask, including running, success, and failed.
-   **snapshotChannelsId:** IDs of input channels for the Checkpoint subtask.
-   **downstreamSubscribeOffsets:** Offsets of downstream subscriptions.
-   **snapshotMeta:** Metadata of the Checkpoint snapshot.
-   **extra:** Additional information, such as error details of the Checkpoint.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaCheckpointSubjobInfo("streamGraph1") // name is the name of the streaming graph
getOrcaCheckpointSubjobInfo("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

