# getOrcaCheckpointJobInfo {#getOrcaCheckpointJobInfo}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaCheckpointJobInfo([name])`

## Arguments {#arguments}

**name** \(optional\) is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

If **name** is not specified, the function returns the Checkpoint job information of all streaming graphs in Orca.

**Return value:** a table containing the following fields:

-   **checkpointId:** Checkpoint ID.
-   **jobId:** Streaming graph ID.
-   **createdTimeStamp:** Creation timestamp of the Checkpoint job.
-   **finishedTimeStamp:** Completion timestamp of the Checkpoint job.
-   **status:** Status of the Checkpoint job:
    -   **RUNNING:** Currently running.
    -   **ERROR:** General error occurred; a new Checkpoint will be retried.
    -   **FAILED:** Critical error occurred; retry is not possible.
    -   **SUCCESS:** Checkpoint completed successfully and is available.
    -   **CANCELED:** Checkpoint job was canceled by the system, typically because multiple Checkpoint jobs are running simultaneously in the same graph; when the latest Checkpoint succeeds, the system automatically cancels older Checkpoints.
    -   **PURGED:** The system retains only the most recent successful Checkpoints \(managed by the parameter maxRetainedCheckpoints\); older Checkpoints will be automatically cleaned up.
-   **extra:** Additional information, such as error details of the Checkpoint.
-   **partitionId:** The ID of the partition where the checkpoint metadata is located.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getOrcaCheckpointJobInfo("streamGraph1")// name is the name of the streaming graph
getOrcaCheckpointJobInfo("catalog1.orca_graph.streamGraph1") // name is the fully qualified name
```

