# getOrcaCheckpointConfig {#getOrcaCheckpointConfig}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getOrcaCheckpointConfig(name)`

## Arguments {#arguments}

**name** is a string representing the name of the stream graph. You can provide either the fully qualified name \(FQN\), such as "catalog\_name.orca\_graph.graph\_name", or just the graph name, like "factors". If only the name is given, the system will automatically complete it using the current catalog.

## Details {#details}

Retrieve the Checkpoint configuration of the specified streaming graph.

**Return value:** a dictionary containing the following fields:

<table id="table_uzn_dlj_3fc"><thead><tr><th align="left">

key

</th><th align="left">

Description

</th></tr></thead><tbody><tr><td align="left">

enable

</td><td align="left">

Whether Checkpoint is enabled

</td></tr><tr><td align="left">

checkpointMod

</td><td align="left">

Consistency level of the streaming graph, excluding sink nodes: -   exactly\_once: Exactly-once
-   executionat\_least\_once: At-least-once execution

</td></tr><tr><td align="left">

interval

</td><td align="left">

Time interval to trigger Checkpoint, in milliseconds

</td></tr><tr><td align="left">

timeout

</td><td align="left">

Timeout for Checkpoint. If Checkpoint is not completed within the specified time, it will be considered failed, in milliseconds

</td></tr><tr><td align="left">

alignedTimeout

</td><td align="left">

Timeout for Barrier alignment. If alignment is not completed within the specified time, the Checkpoint will be considered failed, in milliseconds

</td></tr><tr><td align="left">

minIntervalBetweenCkpt

</td><td align="left">

Minimum time interval between the completion of the last Checkpoint and the initiation of the next Checkpoint

</td></tr><tr><td align="left">

consecutiveFailures

</td><td align="left">

Maximum number of consecutive Checkpoint failures. If exceeded, the status of the entire streaming graph will be switched to ERROR.

</td></tr><tr><td align="left">

maxConcurrentCheckpoints

</td><td align="left">

Maximum number of concurrent Checkpoints allowed. Please note that allowing concurrent Checkpoints may impact running streaming jobs.

</td></tr><tr><td align="left">

maxRetainedCheckpoints

</td><td align="left">

The system will periodically clean up historical Checkpoint data.

</td></tr></tbody>
</table>## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
// where name is the name of the streaming graph
getOrcaCheckpointConfig("streamGraph1")

// where name is the fully qualified name
getOrcaCheckpointConfig("catalog1.orca_graph.streamGraph1")

```

