# getLocalIOTDBStaticTable {#getLocalIOTDBStaticTable}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getLocalIOTDBStaticTable(dbUrl, tableName, [dfsPath])`

## Arguments {#arguments}

**dbUrl** is a STRING scalar indicating the path to a DFS database.

**tableName** is a STRING scalar indicating the table name.

**dfsPath** is the DFS path to a database chunk. It can be derived by removing the time partition and any subsequent components from the `dfsPath` column in the result of `getChunksMeta`. For example, if a chunk's `dfsPath` is `/db/Key1/20250428/gP`, this parameter should be set to `/db/Key1`. By default, the function returns all static tables of the *tableName* at the local node.

## Details {#details}

Retrive the static table at the local node. This function can only be called on the data node by the users with TABLE\_READ privilege to the table or DB\_READ privilege to the database.

Return value:

A table with the following columns:

-   innerId: The internal ID corresponding to the measurement point.
-   Measurement point columns: They are determined by the sort key \(the sort columns except for the last column\). If one column is named `id` or `type`, it will be automatically renamed to `_id_` or `_type_` in the returned table.
-   valueType: The type of the IOTANY column corresponding to the measurement point.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getLocalIOTDBStaticTable(dbUrl="dfs://db", tableName="pt", dfsPath="/db/Key1")
```

|innerId|deviceId|location|valueType|
|-------|--------|--------|---------|
|1|1|loc2|DOUBLE|
|0|1|loc1|INT|

