# getLoadedPlugins {#getLoadedPlugins}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getLoadedPlugins()`

## Arguments {#arguments}

None

## Details {#details}

This function retrieves a list of plugins loaded on the node.

**Return value:** A table containing the following columns:

-   plugin: name of the plugin.
-   version: plugin version as specified in the *Plugin&lt;name&gt;.txt* file.
-   user: name of the user who loaded the plugin.
-   time: date and time when the plugin was loaded.

## Examples {#examples}

``` {#codeblock_e3l_h51_ddc}
login("admin","123456")
loadPlugin("zip")
login("user1","123456")
loadPlugin("httpclient")

getLoadedPlugins()
```

Output:

|plugin|version|user|time|
|------|-------|----|----|
|zip|3.00.1|admin|2024.09.01T10:00:01.000|
|httpClient|3.00.1|user1|2024.09.01T10:00:02.000|

