# getLeftStream {#getleftstream}

## Syntax {#id_x2g_lf5_hzb}

`getLeftStream(joinEngine)`

## Arguments {#arguments}

**joinEngine** is a table object returned by creating a join engine. The join engines currently supported by DolphinDB are:

-   createAsofJoinEngine

-   createEquiJoinEngine

-   createLookupJoinEngine

-   createWindowJoinEngine

-   createLeftSemiJoinEngine

## Details {#details}

Return the schema of the left table of the join engine. The data ingested into this schema will be ingested into *joinEngine*.

The result of an engine can be ingested into the join engine to realize the cascade between engines.

## Examples {#examples}

```
share streamTable(1000:0, `time`sym`price, [TIMESTAMP, SYMBOL, DOUBLE]) as trades

output=table(100:0, `timestamp`sym`price1`price2, [TIMESTAMP, SYMBOL, DOUBLE, DOUBLE])

leftTable=table(1:0, `sym`timestamp`price, [SYMBOL, TIMESTAMP, DOUBLE])
rightTable=table(1:0, `sym`timestamp`price, [SYMBOL, TIMESTAMP, DOUBLE])

ajEngine = createAsofJoinEngine("asofjoin_engine", leftTable, rightTable, output, <[leftTable.price, rightTable.price]>, `sym, `timestamp)

leftEngine = createReactiveStateEngine(name=`left_reactive_engine, metrics=<[time,msum(price,3)]>, dummyTable=trades, outputTable=getLeftStream(ajEngine), keyColumn="sym")
rightEngine = createReactiveStateEngine(name=`right_reactive_engine, metrics=<[time,mfirst(price,3)]>, dummyTable=trades, outputTable=getRightStream(ajEngine), keyColumn="sym")

subscribeTable(, "trades", "left_reactive_engine", 0, append!{leftEngine}, true)
subscribeTable(, "trades", "right_reactive_engine", 0, append!{rightEngine}, true)

t = table(2022.01.01 + 1..20 as time, take(`AMZN`IBM`APPL, 20) as sym, rand(100.0, 20) as price)
trades.append!(t)
select * from output order by timestamp,sym
```

|timestamp|sym|price1|price2|
|---------|---|------|------|
|2022.01.02T00:00:00.000|AMZN|||
|2022.01.03T00:00:00.000|IBM|||
|2022.01.04T00:00:00.000|APPL|||
|2022.01.05T00:00:00.000|AMZN|||
|2022.01.06T00:00:00.000|IBM|||
|2022.01.07T00:00:00.000|APPL|||
|2022.01.08T00:00:00.000|AMZN|102.192|26.2273|
|2022.01.09T00:00:00.000|IBM|152.2704|43.6296|
|2022.01.10T00:00:00.000|APPL|126.1056|74.929|
|2022.01.11T00:00:00.000|AMZN|137.4656|57.6015|
|2022.01.12T00:00:00.000|IBM|116.7775|54.2854|
|2022.01.13T00:00:00.000|APPL|58.8909|49.3149|
|2022.01.14T00:00:00.000|AMZN|148.5405|18.3633|
|2022.01.15T00:00:00.000|IBM|141.0848|54.3554|
|2022.01.16T00:00:00.000|APPL|93.9003|1.8618|
|2022.01.17T00:00:00.000|AMZN|210.4329|61.5008|
|2022.01.18T00:00:00.000|IBM|88.7772|8.1367|

Related function: [getRightStream](getRightStream.md).

