# getJobStatus {#getjobstatus}

## Syntax {#syntax}

`getJobStatus(jobId)`

## Arguments {#arguments}

**jobId** is a string indicating the batch job ID.

## Details {#details}

Retrieve the status of a batch job. It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|node|the alias of the local node|
|userID|the user ID|
|jobId|the job ID|
|rootJobId|the root job ID|
|jobDesc|the job description|
|priority|priority of the job which is marked as integers ranging from 0 to 9|
|parallelism|the parallelism, i.e., the maximum number of jobs that can run in parallel|
|clientIp|the IP address of the client where the job is submitted|
|clientPort|the port number of the client where the job is submitted|
|receivedTime|the time \(of TIMESTAMP type\) when a job is received by the node|
|startTime|the start time of jobs \(of TIMESTAMP type\)|
|endTime|the end time of jobs \(of TIMESTAMP type\)|
|errorMessage|error messages|

For details about batch jobs please refer to [Batch Job Management](../../Maintenance/BatchJobManagement.md).

## Examples {#examples}

```
def job1(n){
   s = 0
   for (x in 1 : n) {
       s += sum(sin rand(1.0, 100000000)-0.5)
       print("iteration " + x + " " + s)
   }
   return s
}

job1_ID=submitJob("job1_ID","", job1, 100);
getJobStatus(job1_ID);
```

|node|userID|jobId|rootJobId|jobDesc|priority|parallelism|clientIP|clientPort|receivedTime|startTime|endTime|errorMsg|
|----|------|-----|---------|-------|--------|-----------|--------|----------|------------|---------|-------|--------|
|controller2|guest|job1\_ID20210428...|b9263bfd-50b8-70b3-9845-e595f9b0c506|job1|4|1|115.204.199.28|61537|2023.12.12T02:50:32.598| | ||

*endTime* is empty. This means the job is still running. After the job is completed, rerun `getJobStatus`:

```
getJobStatus(job1_ID);
```

<table><tbody><tr><td>

node

</td><td>

userID

</td><td>

jobId

</td><td>

rootJobId

</td><td>

jobDesc

</td><td>

priority

</td><td>

parallelism

</td><td>

clientIP

</td><td>

clientPort

</td><td>

receivedTime

</td><td>

startTime

</td><td>

endTime

</td><td>

errorMsg

</td></tr><tr><td>

controller2

</td><td>

guest

</td><td>

job1\_ID20210428...

</td><td>

b9263bfd-50b8-70b3-9845-e595f9b0c506

</td><td>

job1

</td><td>

4

</td><td>

1

</td><td>

115.204.199.28

</td><td>

61537

</td><td>

2023.12.12T02:50:32.598

</td><td>

2023.12.12T02:50:32.599

</td><td>

2023.12.12T02:52:32.477

</td><td>



</td></tr></tbody>
</table>