# getDBAccess {#getDBAccess}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getDBAccess(dbUrl)`

## Arguments {#arguments}

**dbUrl** is a string indicating the database URL.

## Details {#details}

Allow users to get a detailed view of users and groups with privileges of the specified database.

**Note:**This function can only be invoked by administrators or by users with DB\_OWNER or DB\_MANAGE privileges of the database.

**Return value**: A table with the following columns:

-   name: The user or group name.
-   type: User or group.
-   DB\_READ, DB\_INSERT, DB\_UPDATE, DB\_DELETE, DBOBJ\_CREATE, DBOBJ\_DELETE, DB\_MANAGE: The specific privileges. The states can be ALLOW, DENY, or NONE. For more information on user access privileges, please refer to [User Access Control](../../Tutorials/access_control.md).

## Examples {#examples}

User1 with the DB\_OWNER privilege creates the database dfs://testDB with following settings:

-   Grants DB\_READ privilege to user2.
-   Denies DB\_INSERT privilege to user3.
-   Grants DBOBJ\_CREATE privilege to group1.

Use getDBAccess to view the permission set of testDB.

``` {#codeblock_qcg_mxg_mcc}
login(`user1, `123456)
getDBAccess("dfs://testDB")
```

Output:

|name|type|DB\_READ|DB\_INSERT|DB\_UPDATE|DB\_DELETE|DBOBJ\_CREATE|DBOBJ\_DELETE|DB\_MANAGE|
|:---|:---|:-------|:---------|:---------|:---------|:------------|:------------|:---------|
|group1|group|NONE|NONE|NONE|NONE|ALLOW|NONE|NONE|
|user3|user|NONE|DENY|NONE|NONE|NONE|NONE|NONE|
|user2|user|ALLOW|NONE|NONE|NONE|NONE|NONE|NONE|
|admin|user|ALLOW|ALLOW|ALLOW|ALLOW|ALLOW|ALLOW|ALLOW|

Related functions: [getTableAccess](getTableAccess.md)

