# getConsoleJobs {#getconsolejobs}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getConsoleJobs()`

## Arguments {#arguments}

None

## Details {#details}

Return the descriptive information about the running interactive jobs of the local node.

It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|node|the alias of the local node|
|userID|the user ID|
|rootJobId|the root job ID|
|jobType|the job type|
|desc|the job description|
|priority|priority of the job which is marked as integers ranging from 0 to 9|
|parallelism|the parallelism, i.e., the maximum number of jobs that can run in parallel|
|receiveTime|the time when a job is received by the node|
|sessionId|the ID of the session where the job is submitted|
|remoteIP|the IP address of the client where the job is submitted|
|remotePort|the port number of the client where the job is submitted|
|totalTasks|the total tasks broken down from the job|
|finishedTasks|the number of finished tasks|
|runningTask|the number of running tasks|
|firstTaskStartTime|the start time of the first task|
|latestTaskStartTime|the start time of the latest task|
|queue|the task queues: The value can be normal queue \(for level 0 workers\); web queue \(for web workers\); local task queue \(for level 1-5 workers\); batch job queue|

## Examples {#examples}

```
getConsoleJobs()
```

|node|userID|rootJobId|jobType|desc|priority|parallelism|receiveTime|sessionId|remoteIP|remotePort|totalTasks|finishedTasks|runningTask|firstTaskStartTime|latestTaskStartTime|queue|
|----|------|---------|-------|----|--------|-----------|-----------|---------|--------|----------|----------|-------------|-----------|------------------|-------------------|-----|
|P2-node1|admin|26681f9c-f914-81ae-47dd-8b8e6e106c48|script|getConsoleJobs\(\)|4|2|2022.01.05T11:05:06.778|1823289176|127.0.0.1|50595|1|0|1|2022.01.05T11:05:06.778|2022.01.05T11:05:06.778|normal queue|

