# getComputeNodeCacheDetails {#getComputeNodeCacheDetails}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getComputeNodeCacheDetails(granularity)`

## Arguments {#arguments}

**granularity**: A string scalar that specifies the level of detail for the query:

-   "CHUNK": Queries cache information at the partition level.
-   "TABLE": Queries cache information at the table level. This option is useful when there are many partitions, as it helps control the number of table rows returned.

## Details {#details}

In the storage-compute separation architecture, execute this function on a compute node within a compute group to obtain detailed cache information on that node.

Unlike `getComputeNodeCacheStat`, which provides the overall cache usage and limit for the current node, `getComputeNodeCacheDetails` allows users to query the detailed composition of the cache.

Users can choose to query by table or by partition to view detailed cache information such as the type and size of the cached data.

For details about the storage-compute separation architecture and related configurations, refer to [Storage-Compute Separation](../../Database/DatabaseandDistributedComputing/storage_compute_separation.md).

**Return value:**

-   **When querying by partition** \(*granularity*="CHUNK"\), the function returns a table with the following columns:
    -   dbName: Database name
    -   tableName: Table name
    -   dfsPath: DFS path of the partition
    -   cid: Version identifier for the current cache
    -   cacheType: Type of cache, can be "MEM” or "DISK". If the partition is cached in both, both types will be listed separately.
    -   size: Cache size in bytes, corresponding to the cache type
-   **When querying by table** \(*granularity*="TABLE"\), a single record is returned for each DFS table, containing the following columns:
    -   dbName
    -   tableName
    -   partitionCount: Number of cached partitions in the table
    -   cacheType
    -   size: Total cache size in bytes

## Examples {#examples}

``` {#codeblock_nqb_rms_c2c}
getComputeNodeCacheDetails("CHUNK");
```

|**dbName**|**tableName**|**dfsPath**|**cid**|**cacheType**|**size**|
|----------|-------------|-----------|-------|-------------|--------|
|dfs://demo|pt1|/demo/43/G6|509|MEM|222|
|dfs://demo|pt1|/demo/15/G6|509|MEM|184|
|dfs://test01|pt01|/test01/1/8c|515|MEM|280|
|…||||||

``` {#codeblock_hfm_mwn_1fc}
getComputeNodeCacheDetails("TABLE");
```

|**dbName**|**tableName**|**partitionCount**|**cacheType**|**size**|
|----------|-------------|------------------|-------------|--------|
|dfs://demo|pt1|27|MEM|5804|

**Related functions:**[clearComputeNodeCache](../c/clearComputeNodeCache.md), [clearComputeNodeDiskCache](../c/clearcomputenodediskcache.md), `[getComputeNodeCacheStat](getComputeNodeCacheStat.md)`

