# getCompletedQueries {#getcompletedqueries}

## Syntax {#syntax}

`getCompletedQueries([top])`

## Arguments {#arguments}

**top** \(optional\) is a positive integer. The default value is 10.

## Details {#details}

Return descriptive information about the most recently finished *top* SQL queries on DFS databases at the local node. It returns a table with the following columns:

|Name|Meaning|
|----|-------|
|userID|the user ID|
|sessionID|the session ID|
|jobID|the job ID|
|rootID|the root job ID|
|level|the level of jobs. The root job starts from level 0, the tasks broken down from the root job are marked as level 1, and subtasks level 2, and so on.|
|startTime|the start time of a query \(of NANOTIMESTAMP type\)|
|endTime|the end time of a query \(of NANOTIMESTAMP type\)|
|jobDesc|the job description|
|errorMsg|error messages|
|remoteIP|the IP address of the client that initiates a query|

Only administrators can use this function. Before using the function, set the configuration parameter *perfMonitoring*=1 to enable performance monitoring.

## Examples {#examples}

```
n=1000000
ID=rand(10, n)
x=rand(1.0, n)
t=table(ID, x)
db=database("dfs://rangedb16", RANGE,  0 5 10)
pt = db.createPartitionedTable(t, `pt, `ID)
pt.append!(t)
t1 = select count(x) from pt;
t2 = select * from pt where ID=1;
t3 = select * from pt where ID=5;

getCompletedQueries()
```

|userID|sessionID|jobID|rootID|level|startTime|endTime|jobDesc|errorMsg|remoteIP|
|------|---------|-----|------|-----|---------|-------|-------|--------|--------|
|admin|1166953221|4be0f403-a62d-7bae-4ded-43938cc2b4e9|4be0f403-a62d-7bae-4ded-43938cc2b4e9|0|2021.06.28T18:05:34.366483000|2021.06.28T18:05:34.372467000|select ID,x from pt where ID == 1||127.0.0.1|
|admin|1166953221|9e9132c5-60c2-b3ab-41da-039ad2dcb6ff|4be0f403-a62d-7bae-4ded-43938cc2b4e9|0|2021.06.28T18:05:34.366483000|2021.06.28T18:05:34.372467000|select ID,x from pt where ID == 5||127.0.0.1|
|admin|1166953221|98275891-9c9b-948e-425c-6c3083713d84|98275891-9c9b-948e-425c-6c3083713d84|0|2021.06.28T18:05:34.344272000|2021.06.28T18:05:34.359201000|select count\(x\) as count\_x from pt||127.0.0.1|

```
getCompletedQueries().keys()
// output: ["userID","sessionID","jobID","rootID","level","startTime","endTime","jobDesc","errorMsg"]

getCompletedQueries().ErrorMsg
// output: [,,]

getCompletedQueries().jobDesc
// output: ["select ID,x from pt where ID == 5","select ID,x from pt where ID == 1","select count(x) as count_x from pt"]
```

