# getClusterStatus {#getClusterStatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getClusterStatus(clusterName)`

## Arguments {#arguments}

**clusterName** is a STRING scalar or vector, indicating the name of the cluster.

## Details {#details}

Return the status of a specified cluster. This function can only be executed by an administrator on the MoM \(Master of Masters\) cluster.

**Return value:** A table. Except for the “clusterName” and ”computeGroup” columns, all other fields are consistent with the result of the [getClusterPerf](getClusterPerf.md):

-   clusterName: Name of the cluster.
-   computeGroup: Name of the compute group. If there are no compute group in the cluster, this field will be empty.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
getClusterStatus("ShangHai_cluster2")
```

|clusterName|computeGroup|host|port|site|mode|state|agentSite|maxConnections|maxMemSize|workerNum|executorNum|connectionNum|name|memoryUsed|memoryAlloc|cpuUsage|avgLoad|medLast10QueryTime|maxLast10QueryTime|medLast100QueryTime|maxLast100QueryTime|maxRunningQueryTime|runningJobs|queuedJobs|runningTasks|queuedTasks|jobLoad|diskCapacity|diskFreeSpace|diskFreeSpaceRatio|diskWriteRate|diskReadRate|lastMinuteWriteVolume|lastMinuteReadVolume|networkSendRate|networkRecvRate|lastMinuteNetworkSend|lastMinuteNetworkRecv|publicName|lastMsgLatency|cumMsgLatency|isLeader|
|-----------|------------|----|----|----|----|-----|---------|--------------|----------|---------|-----------|-------------|----|----------|-----------|--------|-------|------------------|------------------|-------------------|-------------------|-------------------|-----------|----------|------------|-----------|-------|------------|-------------|------------------|-------------|------------|---------------------|--------------------|---------------|---------------|---------------------|---------------------|----------|--------------|-------------|--------|
|ShangHai\_cluster2||localhost|8,921|localhost:8921:agent1|1|1|localhost:8921:agent1|32|4|4|0|0|agent1|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0||0|0||
|ShangHai\_cluster2||localhost|8,923|localhost:8923:cnode1|4|0|localhost:8921:agent1|0|0|0|0|0|cnode1|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0||0|0||
|ShangHai\_cluster2||localhost|8,922|localhost:8922:dnode1|0|0|localhost:8921:agent1|0|0|0|0|0|dnode1|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0|0||0|0||
|ShangHai\_cluster2||localhost|8,920|localhost:8920:controller8920|2|1||512|8|4|0|2|controller8920|123,862,496|127,377,408|16.049382716049383|0.16049382716049382|0|0|0|0|0|0|0|0|0|0|0|0|0|148|0|21,028|0|0|0|0|0||0|0||

