# getClusterPerf {#getclusterperf}

## Syntax {#section_wjc_cx1_dzb .section}

`getClusterPerf([includeMaster=false])`

## Arguments {#section_lpt_cx1_dzb .section}

**includeMaster** \(optional\) indicates whether to include the controller information in the output.

## Details {#section_z53_dx1_dzb .section}

Returns configurations and performance measures for each node in the cluster. It returns a table with the following columns:

|Field|Description|Unit|
|-----|-----------|----|
|computeGroup|Compute group name| |
|host|Host name||
|port|Port number||
|site|\(LAN\) site||
|mode|Node type or deployment mode. 0: data node;1: agent; 2: controller; 3: standalone mode; 4: compute node.||
|state|A Boolean value indicating whether the node is alive.||
|agentSite|Agent information of the current node.||
|maxConnections|The maximum number of connections \(from GUI, API, other nodes, etc.\) to the local node.||
|maxMemSize|The maximum memory allocated to DolphinDB.|GB|
|workerNum|The size of worker pool for regular interactive jobs. The default value is the number of CPU cores||
|executorNum|The number of local executors. The default value is the number of CPU cores - 1||
|connectionNum|The number of connections to a local node. Note that the return value for the agent is a random number.||
|name|Node alias||
|memoryUsed|Memory used by the node|Bytes|
|memoryAlloc|Total memory allocated to DolphinDB on the node.|Bytes|
|cpuUsage|CPU usage||
|avgLoad|Average CPU load||
|maxRunningQueryTime|The maximum elapsed time of the queries that are currently running.|ns|
|runningJobs|The number of running jobs||
|queuedJobs|The number of jobs in queue||
|runningTasks|The number of running tasks||
|queuedTasks|The number of tasks in queue||
|jobLoad|CPU load of a job||
|diskCapacity|Disk capacity|Bytes|
|diskFreeSpace|Available disk space|Bytes|
|diskFreeSpaceRatio|Available space ratio||
|diskWriteRate|The rate at which data are written to disk.|Bytes/sec|
|diskReadRate|The rate at which data are read from disk.|Bytes/sec|
|lastMinuteWriteVolume|The data written to disk in the last minute.|Bytes|
|lastMinuteReadVolume|The data read from disk in the last minute.|Bytes|
|networkSendRate|The rate at which data are sent.|Bytes/sec|
|networkRecvRate|The rate at which data are received.|Bytes/sec|
|lastMinuteNetworkSend|Data sent in the last minute|Byte|
|lastMinuteNetworkRecv|Data received in the last minute|Byte|
|publicName|Returns publicName for a controller configured with publicName;Otherwise returns the MAC \(Media Access Control\) Address of the server for a controller, data node or agent.||
|lastMsgLatency|Latency of the last received message|ns|
|cumMsgLatency|Cumulative latency of the messages|ns|
|isLeader|Whether it is the leader of a raft group. It only returns for a raft group of controllers. Note that it will return NULL for a raft group with crashed node.||
|zone|The zone to which the node belongs| |

The following measures are displayed only when the configuration parameter *perfMonitoring* is set to 1.

|Field|Description|Unit|
|-----|-----------|----|
|medLast10QueryTime|The median execution time of the previous 10 finished queries.|ns|
|maxLast10QueryTime|The maximum execution time of the previous 10 finished queries.|ns|
|medLast100QueryTime|The median execution time of the previous 100 finished queries.|ns|
|maxLast100QueryTime|The maximum execution time of the previous 100 finished queries.|ns|

## Examples {#section_vhg_gx1_dzb .section}

``` {#codeblock_qnf_hx1_dzb}
getClusterPerf()
```

