# getChunksMeta {#getchunksmeta}

## Syntax {#syntax}

`getChunksMeta([chunkPath], [top=1024])`

## Arguments {#arguments}

**chunkPath** \(optional\) is the DFS path to one or multiple database chunks. It supports wildcards %, \* and ?.

**top** \(optional\) is a positive number indicating the maximum number of chunks in the output. The default value is 1024. If it is set to -1, the number of returned chunks is not limited.

## Details {#details}

Return metadata of specified database chunks on the local datanode. If *chunkPath* is not specified, return metadata of all database chunks on the local data node.

It returns a table containing the following columns:

-   site: Alias of the node
-   chunkId: The chunk ID
-   path: The path to database chunks
-   dfsPath: The DFS path to database chunks
-   type: The partition type. 0 for file chunk; 1 for tablet chunk.
-   flag: Flag for deletion.
    -   flag=0: The chunk can be queried and accessed.
    -   flag=1: The chunk has been logically marked as deleted and cannot be queried, but it has not been removed from disk.
-   size: The disk space \(in bytes\) occupied by the file chunk. It returns 0 for tablet chunks. Use the [getTabletsMeta](getTabletsMeta.md) function to check the disk space tablet chunk occupies.
-   version: the version number
-   state: Chunk state.
    -   0 \(final state\): Transaction has been completed or rolled back.
    -   1 \(before-commit state\): The transaction is being executed on the chunk, such as writing or deleting data.
    -   2 \(after-commit state\): The transaction has been committed.
    -   3 \(waiting-for-recovery state\): When there is a version conflict or data corruption, this state occurs after the data node sends a recovery request to the controller and before the controller initiates the recovery.
    -   4 \(in-recovery state\): This state occurs after the controller receives the recovery request and initiates the recovery. Upon the completion of recovery, the chunk reverts to the final state \(0\).
-   versionList: version list.
-   resolved: Whether the transaction of the chunk is in the commit phase that needs to be resolved. True indicates the transaction is in the resolution phase or needs to be resolved; False indicates the transaction has already completed the resolution phase or it is not required.

## Examples {#examples}

```
if(existsDatabase("dfs://testDB")){
  dropDatabase("dfs://testDB")
}
db=database("dfs://testDB", VALUE, 1..10)

n=1000000
t=table(rand(1..10, n) as id, rand(100.0, n) as x)
db.createPartitionedTable(t, `p1, `id).append!(t)

n=2000000
t=table(rand(1..10, n) as id, rand(100.0, n) as x, rand(100, n) as y)
db.createPartitionedTable(t, `pt2, `id).append!(t)
getChunksMeta("/testDB%");
```

|site|chunkId|path|dfsPath|type|flag|size|version|state|versionList|resolved|
|----|-------|----|-------|----|----|----|-------|-----|-----------|--------|
|P2-node1|092d5e12-e595-6f9e-b049-83cba1716997|/ssd/ssd5/jzVol…|/testDB/pt2.tbl|0|0|49|1|0|2052:49;|false|
|P2-node1|d31e6b47-18f0-37a6-0146-45bf6e266c56|/ssd/ssd6/jzVol…|/testDB/7|1|0|0|2|0|cid : 2053,pt1…|false|
|P2-node1|cd99d9ef-d864-f3bc-4945-f97017d43bf1|/ssd/ssd5/jzVol…|/testDB/2|1|0|0|2|0|cid : 2053,pt1…|false|
|P2-node1|8da4bea8-31d0-31b5-784f-67aa6339633d|/ssd/ssd5/jzVol…|/testDB/pt1.tbl|0|0|41|1|0|2050:41;|false|
|P2-node1|dd5fc885-f6a6-bfae-8543-254f9fb92484|/ssd/ssd6/jzVol…|/testDB/10|1|0|0|2|0|cid : 2053,pt1…|false|
|P2-node1|4b8aaed1-2dd6-acb7-5148-4add878c3b33|/ssd/ssd6/jzVol…|/testDB/domain|0|0|88|1|0|2049:88;|false|
|P2-node1|28cb59ec-185a-0ebf-a849-267e769936af|/ssd/ssd6/jzVol…|/testDB/8|1|0|0|2|0|cid : 2053,pt1…|false|
|P2-node1|b2facbd2-e301-428f-f94f-8579023f78af|/ssd/ssd6/jzVol…|/testDB/3|1|0|0|2|0|cid : 2053,pt1…|false|
|P2-node1|8bec6445-bc6d-3693-7f46-d1bcdd350182|/ssd/ssd6/jzVol…|/testDB/5|1|0|0|2|0|cid : 2053,pt1…|false|

