# getBackupStatus {#getbackupstatus}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getBackupStatus([userName])`

## Arguments {#arguments}

**userName** is a string indicating the user name.

## Details {#details}

Get the status of backup/restore tasks. Return a table where each row represents the information of a task.

-   userName: user name

-   type: backup/restore types.

    -   BACKUP\_BY\_SQL/RESTORE\_BY\_SQL: backup/restore by SQL statement

    -   BACKUP\_BY\_COPY\_FILE/RESTORE\_BY\_COPY\_FILE: backup/restore by copying files

-   startTime: when the task starts

-   dbName: database path

-   tableName: table name

-   totalPartitions: the number of partitions to be backed up/restored

-   completedPartitions: the number of partitions have been backed up/restored

-   percentComplete: the completion percentage

-   endTime: return the end time of a task if it has ended, otherwise return the estimated completion time

-   completed: whether the task is completed. Return 1 if it is completed, otherwise 0.


**Note:**

-   The number of tasks generated for a backup statement is the same as the number of the backup partitions.

-   Administrators can check the tasks submitted by all users, or the tasks submitted by a specified user by specifying a *userName*.

-   When a non-administrator executes the function, return the status of backup/restore tasks submitted by the current user.


## Examples {#examples}

```
getBackupStatus()
```

|userName|type|startTime|dbName|tableName|totalPartitions|completedPartitions|percentComplete|endTime|completed|
|--------|----|---------|------|---------|---------------|-------------------|---------------|-------|---------|
|u1|BACKUP\_BY\_COPY\_FILE|2022.09.21T17:18:04.264|dfs://valuedb|pt|1|1|100|2022.09.21T17:18:04.269|1|
|u1|BACKUP\_BY\_SQL|2022.09.21T17:13:04.344|dfs://valuedb|pt|4|4|100|2022.09.21T17:13:04.413|1|
|u1|BACKUP\_BY\_COPY\_FILE|2022.09.21T17:18:04.264|dfs://valuedb|pt1|1|1|100|2022.09.21T17:18:04.265|1|
|admin|BACKUP\_BY\_COPY\_FILE|2022.09.21T16:47:42.798|dfs://valuedb|pt|4|4|100|2022.09.21T16:47:42.859|1|
|admin|BACKUP\_BY\_COPY\_FILE|2022.09.21T16:37:33.725|dfs://valuedb|pt|4|4|100|2022.09.21T16:37:33.790|1|
|admin|BACKUP\_BY\_SQL|2022.09.21T15:10:05.016|dfs://compoDB|pt2|10|10|100|2022.09.21T15:10:05.075|1|

