# getBackupMeta {#getbackupmeta}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getBackupMeta(backupDir, dbPath, partition, tableName)`

## Arguments {#arguments}

**backupDir** is a string indicating the directory where the backup is saved.

**dbPath** is a string indicating the path of a DFS database. For example: "dfs://demo".

**partition** is a string indicating the path of a partition under the database. For example: "/20190101/GOOG".

**Note**: For versions 1.30.16/2.00.4 -1.30.18/2.00.6, if *chunkGranularity* is set to "TABLE" when creating the database, *partition* must include the physical index \(which you can get with the `listTables` function\) of the selected partition. For example, if the physical index of the "/20190101/GOOG" partition is 8, then specify partition as "/20190101/GOOG/8" to load its backup information.

**tableName** is a string indicating a distributed table name.

## Details {#details}

Return a dictionary with information about the backup of a partition in a DFS table, which contains the following keys:

-   schema: the schema of the table

-   dfsPath: the DFS path to database chunks

-   rows: the number of records in a chunk

-   chunkID: the chunk ID

-   cid: the commit ID


## Examples {#examples}

```
getBackupMeta("/home/DolphinDB/backup","dfs://valuedb", "/200001M","pt")
/* output:
schema->
name  typeString typeInt extra comment
----- ---------- ------- ----- -------
month MONTH      7
x     INT        4

dfsPath->dfs://valuedb/200001M/b39
rows->750000
chunkID->0061427c-4b24-e3b6-425c-c0e1553d3c35
cid->13349
*/
```

