# getBackupList {#getbackuplist}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`getBackupList(backupDir, dbPath, tableName)`

## Arguments {#arguments}

**backupDir** is a string indicating the directory where the backup is saved.

**dbPath** is a string indicating the path of a distributed database.

**tableName** is a string indicating a distributed table name.

## Details {#details}

Return a table with information about the backups of a DFS table. Each row of the table corresponds to a backed-up partition. The table contains the following columns:

-   chunkID: the chunk ID

-   chunkPath: the DFS path to database chunks

-   cid: the commit ID

-   rows: the number of records in a chunk

-   updateTime: the last update time


## Examples {#examples}

```
if(existsDatabase("dfs://valuedb")){
   dropDatabase("dfs://valuedb")
}
n=3000000
month=take(2000.01M..2000.04M, n);
x=1..n
t=table(month,x);


db=database("dfs://valuedb", VALUE, 2000.01M..2000.04M)
pt = db.createPartitionedTable(t, `pt, `month);
pt.append!(t);
backup("/home/DolphinDB/backup","dfs://valuedb",tableName="pt");
getBackupList("/home/DolphinDB/backup","dfs://valuedb","pt");
```

|chunkID|chunkPath|cid|rows|updateTime|
|-------|---------|---|----|----------|
|0061427c-4b24-e3b6-425c-c0e1553d3c35|dfs://valuedb/200001M/b39|13,348|750,000|2022.09.21T15:45:50.931|
|dabbd90d-6001-f8a9-4d3e-8000d96eba68|dfs://valuedb/200002M/b39|13,348|750,000|2022.09.21T15:45:50.931|
|f5c259b4-4be3-f385-46d4-1a1a2d224e9d|dfs://valuedb/200003M/b39|13,348|750,000|2022.09.21T15:45:50.931|
|6ed58eb9-a2ae-6197-4f81-3186ca1e8b20|dfs://valuedb/200004M/b39|13,348|750,000|2022.09.21T15:45:50.931|

