# getAuditLog {#getAuditLog}

## Syntax {#Syntax .section}

`getAuditLog([userId], [startTime], [endTime], [opType])`

## Arguments {#Arguments .section}

**userId** \(optional\) is a STRING scalar or vector indicating the user ID. If it is not provided \(left as the default value of null\), it means that DDL operations of all users are obtained.

**startTime**\(optional\) is an integral scalar or temporal scalar of DATE, MONTH, DATETIME, TIMESTAMP, DATEHOUR, or NANOTIMESTAMP type. It is the start time of the log. The default value is 1970.01.01.

**endTime**\(optional\) is an integral scalar or temporal scalar of DATE, MONTH, DATETIME, TIMESTAMP, DATEHOUR, or NANOTIMESTAMP type. It is the end time of the log. The default value is null, indicating the current time. Note that *endTime* must be greater than *startTime*.

**opType**\(optional\) is a STRING scalar or vector indicating the operation type. If it is not provided \(left as the default value of null\), it means that all DDL operations are obtained. For *opType* options, see the descriptions in the table following this discussion of Arguments.

## Details {#Details .section}

Obtain the DDL operations of specific *opType* executed by user *userId* between *startTime* and *endTime* \(exclusive\).

It returns a table containing the following columns:

-   userId: The ID of the user perform the operation.
-   startTime: The time when the transaction started.
-   endTime: The time when the transaction ended.
-   dbName: The database name.
-   tbName: The table name.
-   opType: The operation type.
-   opDetail: The detailed operation.
-   tid: The transaction ID.
-   cid: The commit ID.
-   remoteIp: The IP address of the client that submits the operation.
-   remotePort: The port of the client that submits the operation.

The corresponding *opDetail* of each *opType*are shown below:

|opType|opDetail|Description|
|------|--------|-----------|
|CREATE\_DB||create databases|
|DROP\_DB||drop databases|
|CREATE\_TABLE||create dimension tables|
|CREATE\_PARTITIONED\_TABLE||create partitioned tables|
|DROP\_TABLE||drop tables|
|DROP\_PARTITION|deletedPartitions=xxx|drop partitions|
|RENAME\_TABLE|tableName=\[xxx\], newTableName=\[xxx\]|rename tables|
|SQL\_DELETE|script=\[xxx\], deletedRows=xxx|SQL delete|
|SQL\_UPDATE|script=\[xxx\], updatedRows=xxx|SQL update|
|UPSERT|insertedRows=xxx, updatedRows=xxx|update data with `upsert!`|
|ADD\_COLUMN|colName=\[xxx\], colType=\[xxx\]|add columns|
|SET\_COLUMN\_COMMENT|colName=\[xxx\], colComment=\[xxx\]|set column comment|
|TRUNCATE\_TABLE||truncate tables|
|RENAME\_COLUMN|colName=\[xxx\], newColName=\[xxx\]|rename columns|
|REPLACE\_COLUMN|colName=\[xxx\], colType=\[xxx\], newColType=\[xxx\]|replace columns with `replaceColumn!`|
|DROP\_COLUMN|columnName=\[xxx\]|drop columns|
|ADD\_RANGE\_PARTITION||add RANGE partitions with `addRangePartitions`|
|ADD\_VALUE\_PARTITION||add VALUE partitions with `addValuePartitions`|
|APPEND|appendedRows=xxx|append data to databases \(with *atomic*='TRANS'\) or dimension tables of databases \(with *atomic*='CHUNKS'\)|
|APPEND\_CHUNK\_GRANULARITY|appendedRows=xxx|append data to partitioned tables of databases \(with *atomic*='CHUNKS'\)|

## Examples {#examples .section}

``` {#codeblock_nyh_wlv_x1c}
// Perform DDL operations
login("admin","123456")
n = 3
id = rand(`st0001`st0002`st0003`st0004`st0005, n)
sym = rand(`A`B, n)
tradeDate = take(2022.01.01..2022.01.10, 3)
val = 1..n
dummyTb = table(id, sym,tradeDate, val)

dbPath = "dfs://auditTest"
if(existsDatabase(dbPath)){dropDatabase(dbPath)}
db = database(directory=dbPath, partitionType=VALUE, partitionScheme=2022.01.01..2022.01.05, engine='TSDB')
pt = createPartitionedTable(dbHandle=db, table=dummyTb, tableName="snap", partitionColumns=`TradeDate, sortColumns=`id`tradeDate, keepDuplicates=ALL)
pt.append!(dummyTb)

renameTable(db, `snap, `snap_2)

// Get the log of the above operations
getAuditLog()
```

Output:

|userName|startTime|endTime|dbName|tbName|opType|opDetail|tid|cid|remoteIp|
|--------|---------|-------|------|------|------|--------|---|---|--------|
|admin|2024.03.26 14:40:43.659196080|2024.03.26 14:40:43.676082419|dfs://auditTest||CREATE\_DB||1|1|192.168.0.140|
|admin|2024.03.26 14:40:43.676154581|2024.03.26 14:40:43.687319577|dfs://auditTest|snap|CREATE\_PARTITIONED\_TABLE||2|2|192.168.0.140|
|admin|2024.03.26 14:40:45.135000207|2024.03.26 14:40:45.160530442|dfs://auditTest|snap|RENAME\_TABLE|tableName=\[snap\], newTableName=\[snap\_2\]|4|4|192.168.0.14|

**Parent topic:**[Functions](../../Functions/category.md)

