# generateUserTicket {#generateuserticket}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`generateUserTicket(userName, expire)`

## Arguments {#arguments}

**userName**is a STRING scalar indicating the user name for which the login ticket will be generated.

**expire** is a DATETIME scalar indicating the expiration time of the ticket.

## Details {#details}

An administrator can use this function to generate a dynamic login ticket for the user and set the expiration time of the ticket. The user can then use the generated ticket for passwordless login via the `authenticateByTicket(ticket)` function.

## Examples {#examples}

``` {#codeblock_zq1_tms_c2c}
login("admin", "123456")
createUser("user1", "123456")
tik = generateUserTicket("user1", 2030.12.31T12:00:00)
authenticateByTicket(tik)
//check the user of the current session
getCurrentSessionAndUser() 
// output: (1659657455,"user1","192.168.1.177",57958)
```

