# gema {#gema}

## Syntax {#syntax}

`gema(X, window, alpha)`

Please see [TA-Lib Functions](../Themes/TALib.md) for the parameters and windowing logic.

## Arguments {#arguments}

**alpha** is a floating-point number in \(0,1\) indicating the smoothing factor alpha.

## Details {#details}

Calculate the Exponential Moving Average \(ema\) for *X* in a sliding window of the given length.

Different from [ema](../e/ema.md), the function `gema` uses a smoothing factor alpha for EMA. The formula is:

![](../../images/gema.png)

where ![](../../images/gema_k.png) is the *k-th* exponential moving average, *alpha* is the smoothing factor, and Xk is the *k-th* element of the vector *X*.

## Examples {#examples}

```
x=12.1 12.2 12.6 12.8 11.9 11.6 11.2
gema(x,3,0.5);
// output: [,,12.299999999999998,12.55,12.225000000000001,11.912500000000001,11.55625]

x=matrix(12.1 12.2 12.6 12.8 11.9 11.6 11.2, 14 15 18 19 21 12 10)
gema(x,3,0.1);
```

|col1|col2|
|----|----|
|||
|||
|12.3|15.6667|
|12.35|16|
|12.305|16.5|
|12.2345|16.05|
|12.131|15.445|

Related functions: [ema](../e/ema.md), [wilder](../w/wilder.md), [tema](../t/tema.md)

