# ge {#ge}

**Parent topic:**[Functions](../../Functions/category.md)

## Syntax {#syntax}

`ge(X, Y)`

or

`X>=Y`

## Arguments {#arguments}

**X** / **Y** can be a scalar/pair/vector/matrix/set. If X or Y is a pair/vector/matrix, the other is a scalar or a pair/vector/matrix of the same size.

## Details {#details}

If neither *X* nor *Y* is a set, return the element-by-element comparison of *X*&gt;=*Y*.

If both *X* and *Y* are sets, check if *Y* is a subset of *X*.

## Examples {#examples}

```
1 2 3 >= 2;
// output: [false,true,true]

1 2 3 >= 0 2 4;
// output: [true,true,false]

2:3>=1:6;
// output: [true,false]

m1=1..6$2:3;
m1;
```

|\#0|\#1|\#2|
|---|---|---|
|1|3|5|
|2|4|6|

```
m1 ge 4;
```

|\#0|\#1|\#2|
|---|---|---|
|false|false|true|
|false|true|true|

```
m2=6..1$2:3;
m2;
```

|\#0|\#1|\#2|
|---|---|---|
|6|4|2|
|5|3|1|

```
m1>=m2;
```

|\#0|\#1|\#2|
|---|---|---|
|false|false|true|
|false|true|true|

Set operation: If X&gt;=Y then Y is a subset of X

```
x=set(4 6);
x;
// output: set(6,4)

y=set(8 9 4 6);
y;
// output: set(6,4,9,8)

y>=x;
// output: true

x>=y;
// output: false

x>=x;
// output: true  
// x is a subset of x
```

